/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.parsers;

import com.databricks.spark.xml.XmlOptions;
import com.databricks.spark.xml.parsers.StaxXmlParserUtils$;
import com.databricks.spark.xml.util.PartialResultException;
import com.databricks.spark.xml.util.TypeCast$;
import com.databricks.spark.xml.util.ValidatorUtil$;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class StaxXmlParser$
implements Serializable {
    public static final StaxXmlParser$ MODULE$ = new StaxXmlParser$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public RDD<Row> parse(RDD<String> xml, StructType schema, XmlOptions options) {
        return xml.mapPartitions((Function1 & Serializable)iter -> {
            Option xsdSchema = Option$.MODULE$.apply((Object)options.rowValidationXSDPath()).map((Function1 & Serializable)path -> ValidatorUtil$.MODULE$.getSchema((String)path));
            return iter.flatMap((Function1 & Serializable)xml -> MODULE$.doParseColumn((String)xml, schema, options, options.parseMode(), (Option<Schema>)xsdSchema));
        }, xml.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public Row parseColumn(String xml, StructType schema, XmlOptions options) {
        ParseMode parseMode = options.parseMode();
        PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
        ParseMode parseMode2 = !(parseMode != null ? !parseMode.equals(permissiveMode$) : permissiveMode$ != null) && !ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$parseColumn$1(options, x$1))) ? DropMalformedMode$.MODULE$ : options.parseMode();
        Option xsdSchema = Option$.MODULE$.apply((Object)options.rowValidationXSDPath()).map((Function1 & Serializable)path -> ValidatorUtil$.MODULE$.getSchema((String)path));
        return (Row)this.doParseColumn(xml, schema, options, parseMode2, (Option<Schema>)xsdSchema).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<Row> doParseColumn(String xml, StructType schema2, XmlOptions options, ParseMode parseMode, Option<Schema> xsdSchema) {
        Option<Row> option;
        try {
            xsdSchema.foreach((Function1 & Serializable)schema -> {
                StaxXmlParser$.$anonfun$doParseColumn$1(xml, schema);
                return BoxedUnit.UNIT;
            });
            XMLEventReader parser = StaxXmlParserUtils$.MODULE$.filteredReader(xml);
            Attribute[] rootAttributes = StaxXmlParserUtils$.MODULE$.gatherRootAttributes(parser);
            option = new Option<Row>((Object)this.convertObject(parser, schema2, options, rootAttributes));
        }
        catch (Throwable throwable) {
            Option option2;
            Option<Row> option3;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof PartialResultException) {
                PartialResultException partialResultException = (PartialResultException)throwable2;
                option3 = this.failedRecord(xml, options, parseMode, schema2, partialResultException.cause(), (Option<Row>)new Some((Object)partialResultException.partialResult()));
            } else if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option2.get();
                option3 = this.failedRecord(xml, options, parseMode, schema2, e, this.failedRecord$default$6());
            } else {
                throw throwable;
            }
            option = option3;
        }
        return option;
    }

    private Option<Row> failedRecord(String record, XmlOptions options, ParseMode parseMode, StructType schema, Throwable cause, Option<Row> partialResult) {
        None$ none$;
        String abbreviatedRecord = (record.length() > 1000 ? new StringBuilder(3).append(record.substring(0, 1000)).append("...").toString() : record).replaceAll("\n", "");
        ParseMode parseMode2 = parseMode;
        if (FailFastMode$.MODULE$.equals(parseMode2)) {
            this.logger().info("Malformed line:", (Object)abbreviatedRecord);
            this.logger().debug("Caused by:", cause);
            throw new IllegalArgumentException("Malformed line in FAILFAST mode", cause);
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            this.logger().info("Malformed line:", (Object)abbreviatedRecord);
            this.logger().debug("Caused by:", cause);
            none$ = None$.MODULE$;
        } else if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            this.logger().debug("Malformed line:", (Object)abbreviatedRecord);
            this.logger().debug("Caused by:", cause);
            Object[] resultRow = new Object[schema.length()];
            ((IterableOnceOps)schema.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$failedRecord$1(options, x$2)))).foreach((Function1 & Serializable)from -> {
                StaxXmlParser$.$anonfun$failedRecord$2(schema, resultRow, partialResult, from);
                return BoxedUnit.UNIT;
            });
            Option corruptFieldIndex = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> schema.fieldIndex(options.columnNameOfCorruptRecord())).toOption();
            corruptFieldIndex.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                resultRow$1[x$4] = record;
            });
            none$ = new Some((Object)Row$.MODULE$.fromSeq((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.genericArrayOps((Object)resultRow))));
        } else {
            throw new MatchError((Object)parseMode2);
        }
        return none$;
    }

    private Throwable failedRecord$default$5() {
        return null;
    }

    private Option<Row> failedRecord$default$6() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertField(XMLEventReader parser, DataType dataType, XmlOptions options, Attribute[] attributes) {
        Tuple2 tuple2;
        while (true) {
            Object object;
            XMLEvent c;
            if ((tuple2 = new Tuple2((Object)parser.peek(), (Object)dataType)) != null) {
                DataType dt = (DataType)tuple2._2();
                if (tuple2._1() instanceof StartElement && dt != null) {
                    DataType dataType2 = dt;
                    return this.convertComplicatedType$1(dataType2, attributes, parser, options);
                }
            }
            if (tuple2 != null && tuple2._1() instanceof EndElement && tuple2._2() instanceof StringType) {
                if (options.treatEmptyValuesAsNulls()) return null;
                String string = options.nullValue();
                String string2 = "";
                if (string != null) {
                    if (!string.equals(string2)) return "";
                    return null;
                }
                if (string2 == null) return null;
                return "";
            }
            if (tuple2 != null && tuple2._1() instanceof EndElement && tuple2._2() != null) {
                return null;
            }
            if (tuple2 != null) {
                XMLEvent c2 = (XMLEvent)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (c2 instanceof Characters) {
                    Characters characters = (Characters)c2;
                    if (dataType3 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType3;
                        DataType st = arrayType.elementType();
                        return TypeCast$.MODULE$.convertTo(characters.getData(), st, options);
                    }
                }
            }
            if (tuple2 != null) {
                XMLEvent c3 = (XMLEvent)tuple2._1();
                DataType st = (DataType)tuple2._2();
                if (c3 instanceof Characters) {
                    Characters characters = (Characters)c3;
                    if (st instanceof StructType) {
                        Object object2;
                        StructType structType = (StructType)st;
                        boolean attributesOnly = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$convertField$1(options, f)));
                        if (attributesOnly) {
                            object2 = structType.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$convertField$2(options, x$5))).map((Function1 & Serializable)valueTag -> TypeCast$.MODULE$.convertTo(characters.getData(), valueTag.dataType(), options)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                            return object2;
                        } else {
                            parser.next();
                            XMLEvent xMLEvent = parser.peek();
                            if (xMLEvent instanceof EndElement) {
                                return null;
                            }
                            Row row = this.convertObject(parser, structType, options, this.convertObject$default$4());
                            object2 = row;
                        }
                        return object2;
                    }
                }
            }
            if (tuple2 != null && tuple2._1() instanceof Characters && tuple2._2() instanceof StringType) {
                return TypeCast$.MODULE$.convertTo(StaxXmlParserUtils$.MODULE$.currentStructureAsString(parser), (DataType)StringType$.MODULE$, options);
            }
            if (tuple2 == null || !((c = (XMLEvent)tuple2._1()) instanceof Characters)) break;
            Characters characters = (Characters)c;
            if (tuple2._2() == null || !characters.isWhiteSpace()) break;
            String data = characters.getData();
            parser.next();
            boolean bl = false;
            EndElement endElement = null;
            XMLEvent xMLEvent = parser.peek();
            if (xMLEvent instanceof StartElement) {
                object = this.convertComplicatedType$1(dataType, attributes, parser, options);
                return object;
            }
            if (xMLEvent instanceof EndElement) {
                bl = true;
                endElement = (EndElement)xMLEvent;
                if (data.isEmpty()) {
                    return null;
                }
            }
            if (bl && options.treatEmptyValuesAsNulls()) {
                return null;
            }
            if (!bl) continue;
            object = TypeCast$.MODULE$.convertTo(data, dataType, options);
            return object;
        }
        if (tuple2 != null) {
            XMLEvent c = (XMLEvent)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (c instanceof Characters) {
                Characters characters = (Characters)c;
                if (dt != null) {
                    DataType dataType4 = dt;
                    return TypeCast$.MODULE$.convertTo(characters.getData(), dataType4, options);
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        XMLEvent e = (XMLEvent)tuple2._1();
        DataType dt = (DataType)tuple2._2();
        if (e == null) throw new MatchError((Object)tuple2);
        XMLEvent xMLEvent = e;
        if (dt == null) throw new MatchError((Object)tuple2);
        DataType dataType5 = dt;
        throw new IllegalArgumentException(new StringBuilder(50).append("Failed to parse a value for data type ").append(dataType5).append(" with event ").append(xMLEvent.toString()).toString());
    }

    public Attribute[] convertField$default$4() {
        return (Attribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Attribute.class));
    }

    private Map<String, Object> convertMap(XMLEventReader parser, DataType valueType, XmlOptions options, Attribute[] attributes) {
        ArrayBuffer kvPairs = ArrayBuffer$.MODULE$.empty();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])attributes), (Function1 & Serializable)attr -> (ArrayBuffer)kvPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(options.attributePrefix()).append(attr.getName().getLocalPart()).toString()), (Object)attr.getValue())));
        boolean shouldStop = false;
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xMLEvent;
                boxedUnit = kvPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StaxXmlParserUtils$.MODULE$.getName(startElement.asStartElement().getName(), options)), this.convertField(parser, valueType, options, this.convertField$default$4())));
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = StaxXmlParserUtils$.MODULE$.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return kvPairs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Object> convertAttributes(Attribute[] attributes, StructType schema, XmlOptions options) {
        scala.collection.mutable.Map convertedValuesMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Map<String, String> valuesMap = StaxXmlParserUtils$.MODULE$.convertAttributesToValuesMap(attributes, options);
        valuesMap.foreach((Function1 & Serializable)x0$1 -> {
            StaxXmlParser$.$anonfun$convertAttributes$1(schema, convertedValuesMap, options, x0$1);
            return BoxedUnit.UNIT;
        });
        return convertedValuesMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Row convertObjectWithAttributes(XMLEventReader parser, StructType schema, XmlOptions options, Attribute[] attributes) {
        Map map;
        Object[] row = new Object[schema.length()];
        Map<String, Object> attributesMap = this.convertAttributes(attributes, schema, options);
        Object object = this.convertField(parser, (DataType)schema, options, this.convertField$default$4());
        if (object instanceof Row) {
            Row row2 = (Row)object;
            map = (Map)Predef$.MODULE$.Map().apply((Seq)((IterableOps)schema.map((Function1 & Serializable)x$7 -> x$7.name())).zip((IterableOnce)row2.toSeq()));
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)options.valueTag())) {
            Map valuesMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Function1 & Serializable)x$8 -> new Tuple2(x$8, null), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            map = (Map)valuesMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)options.valueTag()), object));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map fieldsMap = map;
        Iterable valuesMap = (Iterable)fieldsMap.$plus$plus(attributesMap);
        valuesMap.foreach((Function1 & Serializable)x0$1 -> {
            StaxXmlParser$.$anonfun$convertObjectWithAttributes$3(schema, row, x0$1);
            return BoxedUnit.UNIT;
        });
        return valuesMap.isEmpty() ? Row$.MODULE$.fromSeq((Seq)package$.MODULE$.Seq().fill(schema.fieldNames().length, (Function0 & Serializable)() -> null)) : Row$.MODULE$.fromSeq((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.genericArrayOps((Object)row)));
    }

    private Row convertObject(XMLEventReader parser, StructType schema, XmlOptions options, Attribute[] rootAttributes) {
        Object[] row = new Object[schema.length()];
        Map nameToIndex = ((IterableOnceOps)((IterableOps)schema.map((Function1 & Serializable)x$11 -> x$11.name())).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.convertAttributes(rootAttributes, schema, options).toSeq().foreach((Function1 & Serializable)x0$1 -> {
            StaxXmlParser$.$anonfun$convertObject$2(nameToIndex, row, x0$1);
            return BoxedUnit.UNIT;
        });
        String wildcardColName = options.wildcardColName();
        boolean hasWildcard = schema.exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$convertObject$4(wildcardColName, x$13)));
        None$ badRecordException = None$.MODULE$;
        boolean shouldStop = false;
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent;
            block28: {
                BoxedUnit boxedUnit2;
                xMLEvent = parser.nextEvent();
                if (!(xMLEvent instanceof StartElement)) break block28;
                StartElement startElement = (StartElement)xMLEvent;
                try {
                    BoxedUnit boxedUnit3;
                    Attribute[] attributes = (Attribute[])CollectionConverters$.MODULE$.IteratorHasAsScala(startElement.getAttributes()).asScala().map((Function1 & Serializable)x$14 -> x$14).toArray(ClassTag$.MODULE$.apply(Attribute.class));
                    String field = StaxXmlParserUtils$.MODULE$.getName(startElement.asStartElement().getName(), options);
                    Option option = nameToIndex.get((Object)field);
                    if (option instanceof Some) {
                        ArrayType arrayType;
                        DataType dt;
                        BoxedUnit boxedUnit4;
                        Some some = (Some)option;
                        int index = BoxesRunTime.unboxToInt((Object)some.value());
                        DataType dataType = schema.apply(index).dataType();
                        if (dataType instanceof StructType) {
                            StructType structType = (StructType)dataType;
                            row[index] = this.convertObjectWithAttributes(parser, structType, options, attributes);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else if (dataType instanceof ArrayType && (dt = (arrayType = (ArrayType)dataType).elementType()) != null) {
                            Object object;
                            DataType dataType2 = dt;
                            ArrayBuffer values = (ArrayBuffer)Option$.MODULE$.apply(row[index]).map((Function1 & Serializable)x$15 -> (ArrayBuffer)x$15).getOrElse((Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty());
                            DataType dataType3 = dataType2;
                            if (dataType3 instanceof StructType) {
                                StructType structType = (StructType)dataType3;
                                object = this.convertObjectWithAttributes(parser, structType, options, attributes);
                            } else if (dataType3 != null) {
                                DataType dataType4 = dataType3;
                                object = this.convertField(parser, dataType4, options, this.convertField$default$4());
                            } else {
                                throw new MatchError((Object)dataType3);
                            }
                            Row newValue = object;
                            row[index] = values.$colon$plus((Object)newValue);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else if (dataType != null) {
                            DataType dataType5 = dataType;
                            row[index] = this.convertField(parser, dataType5, options, attributes);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)dataType);
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit5;
                        if (hasWildcard) {
                            ArrayType arrayType;
                            DataType dataType;
                            BoxedUnit boxedUnit6;
                            Object newValue = this.convertField(parser, (DataType)StringType$.MODULE$, options, this.convertField$default$4());
                            int anyIndex = schema.fieldIndex(wildcardColName);
                            DataType dataType6 = schema.apply(wildcardColName).dataType();
                            if (StringType$.MODULE$.equals(dataType6)) {
                                row[anyIndex] = newValue;
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else if (dataType6 instanceof ArrayType && StringType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType6).elementType())) {
                                ArrayBuffer values = (ArrayBuffer)Option$.MODULE$.apply(row[anyIndex]).map((Function1 & Serializable)x$16 -> (ArrayBuffer)x$16).getOrElse((Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty());
                                row[anyIndex] = values.$colon$plus(newValue);
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError((Object)dataType6);
                            }
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            StaxXmlParserUtils$.MODULE$.skipChildren(parser);
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        boxedUnit3 = boxedUnit5;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable exception;
                    block30: {
                        block29: {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) break block29;
                            exception = (Throwable)option.get();
                            ParseMode parseMode = options.parseMode();
                            PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                            if (!(parseMode != null ? !parseMode.equals(permissiveMode$) : permissiveMode$ != null)) break block30;
                        }
                        throw throwable;
                    }
                    badRecordException = badRecordException.orElse((Function0 & Serializable)() -> new Some((Object)exception));
                    BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = StaxXmlParserUtils$.MODULE$.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!badRecordException.isEmpty()) {
            throw new PartialResultException(Row$.MODULE$.fromSeq((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.genericArrayOps((Object)row))), (Throwable)badRecordException.get());
        }
        return Row$.MODULE$.fromSeq((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.genericArrayOps((Object)row)));
    }

    private Attribute[] convertObjectWithAttributes$default$4() {
        return (Attribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Attribute.class));
    }

    private Attribute[] convertObject$default$4() {
        return (Attribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Attribute.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StaxXmlParser$.class);
    }

    public static final /* synthetic */ boolean $anonfun$parseColumn$1(XmlOptions options$2, StructField x$1) {
        String string = x$1.name();
        String string2 = options$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$doParseColumn$1(String xml$1, Schema schema) {
        schema.newValidator().validate(new StreamSource(new StringReader(xml$1)));
    }

    public static final /* synthetic */ boolean $anonfun$failedRecord$1(XmlOptions options$3, StructField x$2) {
        String string = x$2.name();
        String string2 = options$3.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$failedRecord$2(StructType schema$2, Object[] resultRow$1, Option partialResult$1, StructField from) {
        int sourceIndex = schema$2.fieldIndex(from.name());
        resultRow$1[sourceIndex] = partialResult$1.map((Function1 & Serializable)x$3 -> x$3.get(sourceIndex)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object convertComplicatedType$1(DataType dt, Attribute[] attributes, XMLEventReader parser$1, XmlOptions options$4) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.convertObject(parser$1, structType, options$4, this.convertObject$default$4());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType dataType2 = mapType.keyType();
            DataType vt = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType2)) {
                return this.convertMap(parser$1, vt, options$4, attributes);
            }
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType st = arrayType.elementType();
            return this.convertField(parser$1, st, options$4, this.convertField$default$4());
        }
        if (!(dataType instanceof StringType)) throw new MatchError((Object)dataType);
        return TypeCast$.MODULE$.convertTo(StaxXmlParserUtils$.MODULE$.currentStructureAsString(parser$1), (DataType)StringType$.MODULE$, options$4);
    }

    public static final /* synthetic */ boolean $anonfun$convertField$1(XmlOptions options$4, StructField f) {
        String string = f.name();
        String string2 = options$4.valueTag();
        return !(string == null ? string2 != null : !string.equals(string2)) || f.name().startsWith(options$4.attributePrefix());
    }

    public static final /* synthetic */ boolean $anonfun$convertField$2(XmlOptions options$4, StructField x$5) {
        String string = x$5.name();
        String string2 = options$4.valueTag();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$convertAttributes$1(StructType schema$3, scala.collection.mutable.Map convertedValuesMap$1, XmlOptions options$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String f = (String)tuple2._1();
        String v = (String)tuple2._2();
        Map nameToIndex = ((IterableOnceOps)((IterableOps)schema$3.map((Function1 & Serializable)x$6 -> x$6.name())).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        nameToIndex.get((Object)f).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> convertedValuesMap$1.update((Object)f, TypeCast$.MODULE$.convertTo(v, schema$3.apply(i).dataType(), options$6)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertObjectWithAttributes$3(StructType schema$4, Object[] row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String f = (String)tuple2._1();
        Object v = tuple2._2();
        Map nameToIndex = ((IterableOnceOps)((IterableOps)schema$4.map((Function1 & Serializable)x$9 -> x$9.name())).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        nameToIndex.get((Object)f).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {
            row$1[x$10] = v;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertObject$2(Map nameToIndex$1, Object[] row$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String f = (String)tuple2._1();
        Object v = tuple2._2();
        nameToIndex$1.get((Object)f).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            row$2[x$12] = v;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$convertObject$4(String wildcardColName$1, StructField x$13) {
        String string = x$13.name();
        String string2 = wildcardColName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private StaxXmlParser$() {
    }
}

