/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.util;

import com.databricks.spark.xml.XmlOptions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception$;

public final class TypeCast$ {
    public static final TypeCast$ MODULE$ = new TypeCast$();
    private static final Seq<DateTimeFormatter> supportedXmlDateFormatters = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE}));
    private static final Seq<DateTimeFormatter> supportedXmlTimestampFormatters = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withZone(ZoneId.of("UTC")), DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.of("UTC")), DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_INSTANT}));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object castTo(String datum, DataType castType, XmlOptions options) {
        Object object;
        DataType dataType;
        String string = datum;
        String string2 = options.nullValue();
        if (string == null) {
            if (string2 == null) return null;
        } else if (string.equals(string2)) return null;
        if (options.treatEmptyValuesAsNulls()) {
            String string3 = datum;
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return null;
            } else if (string3.equals(string4)) {
                return null;
            }
        }
        if ((dataType = castType) instanceof ByteType) {
            object = BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(datum)));
        } else if (dataType instanceof ShortType) {
            object = BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(datum)));
        } else if (dataType instanceof IntegerType) {
            object = BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(datum)));
        } else if (dataType instanceof LongType) {
            object = BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(datum)));
        } else if (dataType instanceof FloatType) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable)() -> StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(datum))).getOrElse((Function0)(JFunction0.mcF.sp & Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).floatValue());
        } else if (dataType instanceof DoubleType) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(datum))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).doubleValue());
        } else if (dataType instanceof BooleanType) {
            object = BoxesRunTime.boxToBoolean((boolean)this.parseXmlBoolean(datum));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = Decimal$.MODULE$.apply(new BigDecimal(datum.replaceAll(",", "")), decimalType.precision(), decimalType.scale());
        } else if (dataType instanceof TimestampType) {
            object = this.parseXmlTimestamp(datum, options).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(34).append("cannot convert value ").append(datum).append(" to Timestamp").toString());
            });
        } else if (dataType instanceof DateType) {
            object = this.parseXmlDate(datum, options).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(29).append("cannot convert value ").append(datum).append(" to Date").toString());
            });
        } else {
            if (!(dataType instanceof StringType)) throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported type: ").append(castType.typeName()).toString());
            object = datum;
        }
        Byte by = object;
        return by;
    }

    private boolean parseXmlBoolean(String s) {
        boolean bl;
        block10: {
            block8: {
                block9: {
                    String string = s.toLowerCase(Locale.ROOT);
                    switch (string == null ? 0 : string.hashCode()) {
                        case 48: {
                            if (!"0".equals(string)) break block8;
                            break block9;
                        }
                        case 49: {
                            if ("1".equals(string)) {
                                break;
                            }
                            break block8;
                        }
                        case 3569038: {
                            if ("true".equals(string)) {
                                break;
                            }
                            break block8;
                        }
                        case 97196323: {
                            if (!"false".equals(string)) break block8;
                            break block9;
                        }
                        default: {
                            break block8;
                        }
                    }
                    bl = true;
                    break block10;
                }
                bl = false;
                break block10;
            }
            throw new IllegalArgumentException(new StringBuilder(18).append("For input string: ").append(s).toString());
        }
        return bl;
    }

    private Seq<DateTimeFormatter> supportedXmlDateFormatters() {
        return supportedXmlDateFormatters;
    }

    private Option<Date> parseXmlDate(String value, XmlOptions options) {
        Option option;
        Object object = new Object();
        try {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value)) && Character.isDigit(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(value)))) {
                this.supportedXmlDateFormatters().foreach((Function1 & Serializable)format -> {
                    TypeCast$.$anonfun$parseXmlDate$1(object, value, format);
                    return BoxedUnit.UNIT;
                });
            }
            options.dateFormat().map((Function1 & Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1)).foreach((Function1 & Serializable)format -> {
                TypeCast$.$anonfun$parseXmlDate$3(object, value, format);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Seq<DateTimeFormatter> supportedXmlTimestampFormatters() {
        return supportedXmlTimestampFormatters;
    }

    private Option<Timestamp> parseXmlTimestamp(String value, XmlOptions options) {
        Option option;
        Object object = new Object();
        try {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value)) && Character.isDigit(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(value)))) {
                this.supportedXmlTimestampFormatters().foreach((Function1 & Serializable)format -> {
                    TypeCast$.$anonfun$parseXmlTimestamp$1(object, value, format);
                    return BoxedUnit.UNIT;
                });
            }
            options.timestampFormat().foreach((Function1 & Serializable)formatString -> {
                TypeCast$.$anonfun$parseXmlTimestamp$2(options, object, value, formatString);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertTo(String datum, DataType dataType, XmlOptions options) {
        Object object;
        DataType dataType2;
        String value;
        String string = value = datum != null && options.ignoreSurroundingSpaces() ? datum.trim() : datum;
        String string2 = options.nullValue();
        if (string == null) {
            if (string2 == null) return null;
        } else if (string.equals(string2)) return null;
        if (options.treatEmptyValuesAsNulls()) {
            String string3 = value;
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return null;
            } else if (string3.equals(string4)) {
                return null;
            }
        }
        if (NullType$.MODULE$.equals(dataType2 = dataType)) {
            object = this.castTo(value, (DataType)StringType$.MODULE$, options);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToLong((long)this.signSafeToLong(value, options));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToDouble((double)this.signSafeToDouble(value, options));
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)BooleanType$.MODULE$, options);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)StringType$.MODULE$, options);
        } else if (DateType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)DateType$.MODULE$, options);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)TimestampType$.MODULE$, options);
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToFloat((float)this.signSafeToFloat(value, options));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)ByteType$.MODULE$, options);
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)ShortType$.MODULE$, options);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToInteger((int)this.signSafeToInt(value, options));
        } else {
            if (!(dataType2 instanceof DecimalType)) throw new IllegalArgumentException(new StringBuilder(39).append("Failed to parse a value for data type ").append(dataType).append(".").toString());
            DecimalType decimalType = (DecimalType)dataType2;
            object = this.castTo(value, (DataType)decimalType, options);
        }
        Object object2 = object;
        return object2;
    }

    public boolean isBoolean(String value) {
        boolean bl;
        block7: {
            block6: {
                String string = value.toLowerCase(Locale.ROOT);
                switch (string == null ? 0 : string.hashCode()) {
                    case 3569038: {
                        if ("true".equals(string)) {
                            break;
                        }
                        break block6;
                    }
                    case 97196323: {
                        if ("false".equals(string)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public boolean isDouble(String value) {
        String signSafeValue;
        String string = signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        if (signSafeValue.isEmpty() || !Character.isDigit(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(signSafeValue))) && StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(signSafeValue)) != '.') {
            return false;
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value))) {
            boolean bl;
            char c = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(value));
            switch (c) {
                case 'D': 
                case 'F': 
                case 'd': 
                case 'f': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
            if (bl) {
                return false;
            }
        }
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(signSafeValue))).isDefined();
    }

    public boolean isInteger(String value) {
        String signSafeValue;
        String string = signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        if (signSafeValue.isEmpty() || !Character.isDigit(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(signSafeValue)))) {
            return false;
        }
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(signSafeValue))).isDefined();
    }

    public boolean isLong(String value) {
        String signSafeValue;
        String string = signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        if (signSafeValue.isEmpty() || !Character.isDigit(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(signSafeValue)))) {
            return false;
        }
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(signSafeValue))).isDefined();
    }

    public boolean isTimestamp(String value, XmlOptions options) {
        return this.parseXmlTimestamp(value, options).nonEmpty();
    }

    public boolean isDate(String value, XmlOptions options) {
        return this.parseXmlDate(value, options).nonEmpty();
    }

    public long signSafeToLong(String value, XmlOptions options) {
        long l;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            l = -BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        } else {
            String data = value;
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        }
        return l;
    }

    public double signSafeToDouble(String value, XmlOptions options) {
        double d;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            d = -BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        } else {
            String data = value;
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        }
        return d;
    }

    public int signSafeToInt(String value, XmlOptions options) {
        int n;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            n = -BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        } else {
            String data = value;
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        }
        return n;
    }

    public float signSafeToFloat(String value, XmlOptions options) {
        float f;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            f = -BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        } else {
            String data = value;
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        }
        return f;
    }

    public static final /* synthetic */ void $anonfun$parseXmlDate$1(Object nonLocalReturnKey1$1, String value$1, DateTimeFormatter format) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)Date.valueOf(LocalDate.parse(value$1, format))));
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parseXmlDate$3(Object nonLocalReturnKey1$1, String value$1, DateTimeFormatter format) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)Date.valueOf(LocalDate.parse(value$1, format))));
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parseXmlTimestamp$1(Object nonLocalReturnKey2$1, String value$2, DateTimeFormatter format) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Some((Object)Timestamp.from(Instant.from(format.parse(value$2)))));
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parseXmlTimestamp$2(XmlOptions options$1, Object nonLocalReturnKey2$1, String value$2, String formatString) {
        boolean hasTemporalInformation = formatString.indexOf("V") + formatString.indexOf("z") + formatString.indexOf("O") + formatString.indexOf("X") + formatString.indexOf("x") + formatString.indexOf("Z") != -6;
        DateTimeFormatter format = hasTemporalInformation ? DateTimeFormatter.ofPattern(formatString) : DateTimeFormatter.ofPattern(formatString).withZone((ZoneId)options$1.timezone().map((Function1 & Serializable)x$1 -> ZoneId.of(x$1)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Some((Object)Timestamp.from(Instant.from(format.parse(value$2)))));
        }
        catch (Exception exception) {
            return;
        }
    }

    private TypeCast$() {
    }
}

