/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.client.v1.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.client.v1.model.LogQueryDefinition;
import com.datadog.api.client.v1.model.ProcessQueryDefinition;
import com.datadog.api.client.v1.model.WidgetChangeType;
import com.datadog.api.client.v1.model.WidgetCompareTo;
import com.datadog.api.client.v1.model.WidgetFormula;
import com.datadog.api.client.v1.model.WidgetOrderBy;
import com.datadog.api.client.v1.model.WidgetSort;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"apm_query", "change_type", "compare_to", "event_query", "formulas", "increase_good", "log_query", "network_query", "order_by", "order_dir", "process_query", "profile_metrics_query", "q", "queries", "response_format", "rum_query", "security_query", "show_present"})
public class ChangeWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_CHANGE_TYPE = "change_type";
    private WidgetChangeType changeType;
    public static final String JSON_PROPERTY_COMPARE_TO = "compare_to";
    private WidgetCompareTo compareTo;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private LogQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<WidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_INCREASE_GOOD = "increase_good";
    private Boolean increaseGood;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_ORDER_BY = "order_by";
    private WidgetOrderBy orderBy;
    public static final String JSON_PROPERTY_ORDER_DIR = "order_dir";
    private WidgetSort orderDir;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_PROFILE_METRICS_QUERY = "profile_metrics_query";
    private LogQueryDefinition profileMetricsQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;
    public static final String JSON_PROPERTY_SHOW_PRESENT = "show_present";
    private Boolean showPresent;
    private Map<String, Object> additionalProperties;

    public ChangeWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        this.unparsed |= apmQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public ChangeWidgetRequest changeType(WidgetChangeType changeType) {
        this.changeType = changeType;
        this.unparsed |= !changeType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="change_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(WidgetChangeType changeType) {
        if (!changeType.isValid()) {
            this.unparsed = true;
        }
        this.changeType = changeType;
    }

    public ChangeWidgetRequest compareTo(WidgetCompareTo compareTo) {
        this.compareTo = compareTo;
        this.unparsed |= !compareTo.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="compare_to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetCompareTo getCompareTo() {
        return this.compareTo;
    }

    public void setCompareTo(WidgetCompareTo compareTo) {
        if (!compareTo.isValid()) {
            this.unparsed = true;
        }
        this.compareTo = compareTo;
    }

    public ChangeWidgetRequest eventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        this.unparsed |= eventQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public ChangeWidgetRequest formulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
        for (WidgetFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ChangeWidgetRequest addFormulasItem(WidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<WidgetFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public ChangeWidgetRequest increaseGood(Boolean increaseGood) {
        this.increaseGood = increaseGood;
        return this;
    }

    @Nullable
    @JsonProperty(value="increase_good")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncreaseGood() {
        return this.increaseGood;
    }

    public void setIncreaseGood(Boolean increaseGood) {
        this.increaseGood = increaseGood;
    }

    public ChangeWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        this.unparsed |= logQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public ChangeWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        this.unparsed |= networkQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public ChangeWidgetRequest orderBy(WidgetOrderBy orderBy) {
        this.orderBy = orderBy;
        this.unparsed |= !orderBy.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="order_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(WidgetOrderBy orderBy) {
        if (!orderBy.isValid()) {
            this.unparsed = true;
        }
        this.orderBy = orderBy;
    }

    public ChangeWidgetRequest orderDir(WidgetSort orderDir) {
        this.orderDir = orderDir;
        this.unparsed |= !orderDir.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="order_dir")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetSort getOrderDir() {
        return this.orderDir;
    }

    public void setOrderDir(WidgetSort orderDir) {
        if (!orderDir.isValid()) {
            this.unparsed = true;
        }
        this.orderDir = orderDir;
    }

    public ChangeWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        this.unparsed |= processQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public ChangeWidgetRequest profileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
        this.unparsed |= profileMetricsQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="profile_metrics_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getProfileMetricsQuery() {
        return this.profileMetricsQuery;
    }

    public void setProfileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
    }

    public ChangeWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public ChangeWidgetRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        for (FormulaAndFunctionQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ChangeWidgetRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public ChangeWidgetRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    public ChangeWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        this.unparsed |= rumQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public ChangeWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        this.unparsed |= securityQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public ChangeWidgetRequest showPresent(Boolean showPresent) {
        this.showPresent = showPresent;
        return this;
    }

    @Nullable
    @JsonProperty(value="show_present")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowPresent() {
        return this.showPresent;
    }

    public void setShowPresent(Boolean showPresent) {
        this.showPresent = showPresent;
    }

    @JsonAnySetter
    public ChangeWidgetRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeWidgetRequest changeWidgetRequest = (ChangeWidgetRequest)o;
        return Objects.equals(this.apmQuery, changeWidgetRequest.apmQuery) && Objects.equals(this.changeType, changeWidgetRequest.changeType) && Objects.equals(this.compareTo, changeWidgetRequest.compareTo) && Objects.equals(this.eventQuery, changeWidgetRequest.eventQuery) && Objects.equals(this.formulas, changeWidgetRequest.formulas) && Objects.equals(this.increaseGood, changeWidgetRequest.increaseGood) && Objects.equals(this.logQuery, changeWidgetRequest.logQuery) && Objects.equals(this.networkQuery, changeWidgetRequest.networkQuery) && Objects.equals(this.orderBy, changeWidgetRequest.orderBy) && Objects.equals(this.orderDir, changeWidgetRequest.orderDir) && Objects.equals(this.processQuery, changeWidgetRequest.processQuery) && Objects.equals(this.profileMetricsQuery, changeWidgetRequest.profileMetricsQuery) && Objects.equals(this.q, changeWidgetRequest.q) && Objects.equals(this.queries, changeWidgetRequest.queries) && Objects.equals(this.responseFormat, changeWidgetRequest.responseFormat) && Objects.equals(this.rumQuery, changeWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, changeWidgetRequest.securityQuery) && Objects.equals(this.showPresent, changeWidgetRequest.showPresent) && Objects.equals(this.additionalProperties, changeWidgetRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apmQuery, this.changeType, this.compareTo, this.eventQuery, this.formulas, this.increaseGood, this.logQuery, this.networkQuery, this.orderBy, this.orderDir, this.processQuery, this.profileMetricsQuery, this.q, this.queries, this.responseFormat, this.rumQuery, this.securityQuery, this.showPresent, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangeWidgetRequest {\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    changeType: ").append(this.toIndentedString(this.changeType)).append("\n");
        sb.append("    compareTo: ").append(this.toIndentedString(this.compareTo)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    increaseGood: ").append(this.toIndentedString(this.increaseGood)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    orderBy: ").append(this.toIndentedString(this.orderBy)).append("\n");
        sb.append("    orderDir: ").append(this.toIndentedString(this.orderDir)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    profileMetricsQuery: ").append(this.toIndentedString(this.profileMetricsQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("    showPresent: ").append(this.toIndentedString(this.showPresent)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

