/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Event;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"events", "status"})
public class EventListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<Event> events = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    private Map<String, Object> additionalProperties;

    public EventListResponse events(List<Event> events) {
        this.events = events;
        for (Event item : events) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EventListResponse addEventsItem(Event eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        this.events.add(eventsItem);
        this.unparsed |= eventsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public EventListResponse status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonAnySetter
    public EventListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventListResponse eventListResponse = (EventListResponse)o;
        return Objects.equals(this.events, eventListResponse.events) && Objects.equals(this.status, eventListResponse.status) && Objects.equals(this.additionalProperties, eventListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.status, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventListResponse {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

