/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.FunnelQuery;
import com.datadog.api.client.v1.model.FunnelRequestType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"query", "request_type"})
public class FunnelWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_QUERY = "query";
    private FunnelQuery query;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "request_type";
    private FunnelRequestType requestType;
    private Map<String, Object> additionalProperties;

    public FunnelWidgetRequest() {
    }

    @JsonCreator
    public FunnelWidgetRequest(@JsonProperty(required=true, value="query") FunnelQuery query, @JsonProperty(required=true, value="request_type") FunnelRequestType requestType) {
        this.query = query;
        this.unparsed |= query.unparsed;
        this.requestType = requestType;
        this.unparsed |= !requestType.isValid();
    }

    public FunnelWidgetRequest query(FunnelQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunnelQuery getQuery() {
        return this.query;
    }

    public void setQuery(FunnelQuery query) {
        this.query = query;
    }

    public FunnelWidgetRequest requestType(FunnelRequestType requestType) {
        this.requestType = requestType;
        this.unparsed |= !requestType.isValid();
        return this;
    }

    @JsonProperty(value="request_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunnelRequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(FunnelRequestType requestType) {
        if (!requestType.isValid()) {
            this.unparsed = true;
        }
        this.requestType = requestType;
    }

    @JsonAnySetter
    public FunnelWidgetRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunnelWidgetRequest funnelWidgetRequest = (FunnelWidgetRequest)o;
        return Objects.equals(this.query, funnelWidgetRequest.query) && Objects.equals(this.requestType, funnelWidgetRequest.requestType) && Objects.equals(this.additionalProperties, funnelWidgetRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.requestType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunnelWidgetRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

