/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.HeatMapWidgetDefinitionType;
import com.datadog.api.client.v1.model.HeatMapWidgetRequest;
import com.datadog.api.client.v1.model.WidgetAxis;
import com.datadog.api.client.v1.model.WidgetCustomLink;
import com.datadog.api.client.v1.model.WidgetEvent;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTime;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"custom_links", "events", "legend_size", "requests", "show_legend", "time", "title", "title_align", "title_size", "type", "yaxis"})
public class HeatMapWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<WidgetEvent> events = null;
    public static final String JSON_PROPERTY_LEGEND_SIZE = "legend_size";
    private String legendSize;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<HeatMapWidgetRequest> requests = new ArrayList<HeatMapWidgetRequest>();
    public static final String JSON_PROPERTY_SHOW_LEGEND = "show_legend";
    private Boolean showLegend;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HeatMapWidgetDefinitionType type = HeatMapWidgetDefinitionType.HEATMAP;
    public static final String JSON_PROPERTY_YAXIS = "yaxis";
    private WidgetAxis yaxis;
    private Map<String, Object> additionalProperties;

    public HeatMapWidgetDefinition() {
    }

    @JsonCreator
    public HeatMapWidgetDefinition(@JsonProperty(required=true, value="requests") List<HeatMapWidgetRequest> requests, @JsonProperty(required=true, value="type") HeatMapWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public HeatMapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HeatMapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public HeatMapWidgetDefinition events(List<WidgetEvent> events) {
        this.events = events;
        for (WidgetEvent item : events) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HeatMapWidgetDefinition addEventsItem(WidgetEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<WidgetEvent>();
        }
        this.events.add(eventsItem);
        this.unparsed |= eventsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<WidgetEvent> events) {
        this.events = events;
    }

    public HeatMapWidgetDefinition legendSize(String legendSize) {
        this.legendSize = legendSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="legend_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegendSize() {
        return this.legendSize;
    }

    public void setLegendSize(String legendSize) {
        this.legendSize = legendSize;
    }

    public HeatMapWidgetDefinition requests(List<HeatMapWidgetRequest> requests) {
        this.requests = requests;
        for (HeatMapWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HeatMapWidgetDefinition addRequestsItem(HeatMapWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HeatMapWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<HeatMapWidgetRequest> requests) {
        this.requests = requests;
    }

    public HeatMapWidgetDefinition showLegend(Boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    @Nullable
    @JsonProperty(value="show_legend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public HeatMapWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public HeatMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HeatMapWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public HeatMapWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public HeatMapWidgetDefinition type(HeatMapWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HeatMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(HeatMapWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public HeatMapWidgetDefinition yaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
        this.unparsed |= yaxis.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="yaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetAxis getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
    }

    @JsonAnySetter
    public HeatMapWidgetDefinition putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeatMapWidgetDefinition heatMapWidgetDefinition = (HeatMapWidgetDefinition)o;
        return Objects.equals(this.customLinks, heatMapWidgetDefinition.customLinks) && Objects.equals(this.events, heatMapWidgetDefinition.events) && Objects.equals(this.legendSize, heatMapWidgetDefinition.legendSize) && Objects.equals(this.requests, heatMapWidgetDefinition.requests) && Objects.equals(this.showLegend, heatMapWidgetDefinition.showLegend) && Objects.equals(this.time, heatMapWidgetDefinition.time) && Objects.equals(this.title, heatMapWidgetDefinition.title) && Objects.equals(this.titleAlign, heatMapWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, heatMapWidgetDefinition.titleSize) && Objects.equals(this.type, heatMapWidgetDefinition.type) && Objects.equals(this.yaxis, heatMapWidgetDefinition.yaxis) && Objects.equals(this.additionalProperties, heatMapWidgetDefinition.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.events, this.legendSize, this.requests, this.showLegend, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.yaxis, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeatMapWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    legendSize: ").append(this.toIndentedString(this.legendSize)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    showLegend: ").append(this.toIndentedString(this.showLegend)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    yaxis: ").append(this.toIndentedString(this.yaxis)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

