/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.HourlyUsageAttributionUsageType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonPropertyOrder(value={"hour", "org_name", "public_id", "region", "tag_config_source", "tags", "total_usage_sum", "updated_at", "usage_type"})
public class HourlyUsageAttributionBody {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    public static final String JSON_PROPERTY_TAG_CONFIG_SOURCE = "tag_config_source";
    private String tagConfigSource;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private JsonNullable<Map<String, List<String>>> tags = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TOTAL_USAGE_SUM = "total_usage_sum";
    private Double totalUsageSum;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private String updatedAt;
    public static final String JSON_PROPERTY_USAGE_TYPE = "usage_type";
    private HourlyUsageAttributionUsageType usageType;
    private Map<String, Object> additionalProperties;

    public HourlyUsageAttributionBody hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public HourlyUsageAttributionBody orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public HourlyUsageAttributionBody publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public HourlyUsageAttributionBody region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public HourlyUsageAttributionBody tagConfigSource(String tagConfigSource) {
        this.tagConfigSource = tagConfigSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="tag_config_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTagConfigSource() {
        return this.tagConfigSource;
    }

    public void setTagConfigSource(String tagConfigSource) {
        this.tagConfigSource = tagConfigSource;
    }

    public HourlyUsageAttributionBody tags(Map<String, List<String>> tags) {
        this.tags = JsonNullable.of(tags);
        return this;
    }

    public HourlyUsageAttributionBody putTagsItem(String key, List<String> tagsItem) {
        if (this.tags == null || !this.tags.isPresent()) {
            this.tags = JsonNullable.of(new HashMap());
        }
        try {
            this.tags.get().put(key, tagsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, List<String>> getTags() {
        return this.tags.orElse(null);
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, List<String>>> getTags_JsonNullable() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags_JsonNullable(JsonNullable<Map<String, List<String>>> tags) {
        this.tags = tags;
    }

    public void setTags(Map<String, List<String>> tags) {
        this.tags = JsonNullable.of(tags);
    }

    public HourlyUsageAttributionBody totalUsageSum(Double totalUsageSum) {
        this.totalUsageSum = totalUsageSum;
        return this;
    }

    @Nullable
    @JsonProperty(value="total_usage_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTotalUsageSum() {
        return this.totalUsageSum;
    }

    public void setTotalUsageSum(Double totalUsageSum) {
        this.totalUsageSum = totalUsageSum;
    }

    public HourlyUsageAttributionBody updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public HourlyUsageAttributionBody usageType(HourlyUsageAttributionUsageType usageType) {
        this.usageType = usageType;
        this.unparsed |= !usageType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="usage_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HourlyUsageAttributionUsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(HourlyUsageAttributionUsageType usageType) {
        if (!usageType.isValid()) {
            this.unparsed = true;
        }
        this.usageType = usageType;
    }

    @JsonAnySetter
    public HourlyUsageAttributionBody putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HourlyUsageAttributionBody hourlyUsageAttributionBody = (HourlyUsageAttributionBody)o;
        return Objects.equals(this.hour, hourlyUsageAttributionBody.hour) && Objects.equals(this.orgName, hourlyUsageAttributionBody.orgName) && Objects.equals(this.publicId, hourlyUsageAttributionBody.publicId) && Objects.equals(this.region, hourlyUsageAttributionBody.region) && Objects.equals(this.tagConfigSource, hourlyUsageAttributionBody.tagConfigSource) && Objects.equals(this.tags, hourlyUsageAttributionBody.tags) && Objects.equals(this.totalUsageSum, hourlyUsageAttributionBody.totalUsageSum) && Objects.equals(this.updatedAt, hourlyUsageAttributionBody.updatedAt) && Objects.equals(this.usageType, hourlyUsageAttributionBody.usageType) && Objects.equals(this.additionalProperties, hourlyUsageAttributionBody.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.orgName, this.publicId, this.region, this.tagConfigSource, this.tags, this.totalUsageSum, this.updatedAt, this.usageType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HourlyUsageAttributionBody {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    tagConfigSource: ").append(this.toIndentedString(this.tagConfigSource)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    totalUsageSum: ").append(this.toIndentedString(this.totalUsageSum)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    usageType: ").append(this.toIndentedString(this.usageType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

