/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsGeoIPParserType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"is_enabled", "name", "sources", "target", "type"})
public class LogsGeoIPParser {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target = "network.client.geoip";
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsGeoIPParserType type = LogsGeoIPParserType.GEO_IP_PARSER;
    private Map<String, Object> additionalProperties;

    public LogsGeoIPParser() {
    }

    @JsonCreator
    public LogsGeoIPParser(@JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsGeoIPParserType type) {
        this.sources = sources;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsGeoIPParser isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsGeoIPParser name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsGeoIPParser sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsGeoIPParser addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsGeoIPParser target(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsGeoIPParser type(LogsGeoIPParserType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsGeoIPParserType getType() {
        return this.type;
    }

    public void setType(LogsGeoIPParserType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public LogsGeoIPParser putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsGeoIPParser logsGeoIpParser = (LogsGeoIPParser)o;
        return Objects.equals(this.isEnabled, logsGeoIpParser.isEnabled) && Objects.equals(this.name, logsGeoIpParser.name) && Objects.equals(this.sources, logsGeoIpParser.sources) && Objects.equals(this.target, logsGeoIpParser.target) && Objects.equals(this.type, logsGeoIpParser.type) && Objects.equals(this.additionalProperties, logsGeoIpParser.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.name, this.sources, this.target, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsGeoIPParser {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

