/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.QueryValueWidgetDefinitionType;
import com.datadog.api.client.v1.model.QueryValueWidgetRequest;
import com.datadog.api.client.v1.model.TimeseriesBackground;
import com.datadog.api.client.v1.model.WidgetCustomLink;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTime;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"autoscale", "custom_links", "custom_unit", "precision", "requests", "text_align", "time", "timeseries_background", "title", "title_align", "title_size", "type"})
public class QueryValueWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTOSCALE = "autoscale";
    private Boolean autoscale;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_CUSTOM_UNIT = "custom_unit";
    private String customUnit;
    public static final String JSON_PROPERTY_PRECISION = "precision";
    private Long precision;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<QueryValueWidgetRequest> requests = new ArrayList<QueryValueWidgetRequest>();
    public static final String JSON_PROPERTY_TEXT_ALIGN = "text_align";
    private WidgetTextAlign textAlign;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TIMESERIES_BACKGROUND = "timeseries_background";
    private TimeseriesBackground timeseriesBackground;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private QueryValueWidgetDefinitionType type = QueryValueWidgetDefinitionType.QUERY_VALUE;
    private Map<String, Object> additionalProperties;

    public QueryValueWidgetDefinition() {
    }

    @JsonCreator
    public QueryValueWidgetDefinition(@JsonProperty(required=true, value="requests") List<QueryValueWidgetRequest> requests, @JsonProperty(required=true, value="type") QueryValueWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public QueryValueWidgetDefinition autoscale(Boolean autoscale) {
        this.autoscale = autoscale;
        return this;
    }

    @Nullable
    @JsonProperty(value="autoscale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(Boolean autoscale) {
        this.autoscale = autoscale;
    }

    public QueryValueWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public QueryValueWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public QueryValueWidgetDefinition customUnit(String customUnit) {
        this.customUnit = customUnit;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomUnit() {
        return this.customUnit;
    }

    public void setCustomUnit(String customUnit) {
        this.customUnit = customUnit;
    }

    public QueryValueWidgetDefinition precision(Long precision) {
        this.precision = precision;
        return this;
    }

    @Nullable
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPrecision() {
        return this.precision;
    }

    public void setPrecision(Long precision) {
        this.precision = precision;
    }

    public QueryValueWidgetDefinition requests(List<QueryValueWidgetRequest> requests) {
        this.requests = requests;
        for (QueryValueWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public QueryValueWidgetDefinition addRequestsItem(QueryValueWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<QueryValueWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<QueryValueWidgetRequest> requests) {
        this.requests = requests;
    }

    public QueryValueWidgetDefinition textAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
        this.unparsed |= !textAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="text_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(WidgetTextAlign textAlign) {
        if (!textAlign.isValid()) {
            this.unparsed = true;
        }
        this.textAlign = textAlign;
    }

    public QueryValueWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public QueryValueWidgetDefinition timeseriesBackground(TimeseriesBackground timeseriesBackground) {
        this.timeseriesBackground = timeseriesBackground;
        this.unparsed |= timeseriesBackground.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="timeseries_background")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimeseriesBackground getTimeseriesBackground() {
        return this.timeseriesBackground;
    }

    public void setTimeseriesBackground(TimeseriesBackground timeseriesBackground) {
        this.timeseriesBackground = timeseriesBackground;
    }

    public QueryValueWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public QueryValueWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public QueryValueWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public QueryValueWidgetDefinition type(QueryValueWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QueryValueWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(QueryValueWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public QueryValueWidgetDefinition putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryValueWidgetDefinition queryValueWidgetDefinition = (QueryValueWidgetDefinition)o;
        return Objects.equals(this.autoscale, queryValueWidgetDefinition.autoscale) && Objects.equals(this.customLinks, queryValueWidgetDefinition.customLinks) && Objects.equals(this.customUnit, queryValueWidgetDefinition.customUnit) && Objects.equals(this.precision, queryValueWidgetDefinition.precision) && Objects.equals(this.requests, queryValueWidgetDefinition.requests) && Objects.equals(this.textAlign, queryValueWidgetDefinition.textAlign) && Objects.equals(this.time, queryValueWidgetDefinition.time) && Objects.equals(this.timeseriesBackground, queryValueWidgetDefinition.timeseriesBackground) && Objects.equals(this.title, queryValueWidgetDefinition.title) && Objects.equals(this.titleAlign, queryValueWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, queryValueWidgetDefinition.titleSize) && Objects.equals(this.type, queryValueWidgetDefinition.type) && Objects.equals(this.additionalProperties, queryValueWidgetDefinition.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.autoscale, this.customLinks, this.customUnit, this.precision, this.requests, this.textAlign, this.time, this.timeseriesBackground, this.title, this.titleAlign, this.titleSize, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryValueWidgetDefinition {\n");
        sb.append("    autoscale: ").append(this.toIndentedString(this.autoscale)).append("\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    customUnit: ").append(this.toIndentedString(this.customUnit)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    textAlign: ").append(this.toIndentedString(this.textAlign)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    timeseriesBackground: ").append(this.toIndentedString(this.timeseriesBackground)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

