/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOHistoryResponseErrorWithType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"error_budget_remaining", "errors", "group", "history", "monitor_modified", "monitor_type", "name", "precision", "preview", "sli_value", "span_precision", "uptime"})
public class SLOHistoryMonitor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ERROR_BUDGET_REMAINING = "error_budget_remaining";
    private Map<String, Double> errorBudgetRemaining = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<SLOHistoryResponseErrorWithType> errors = null;
    public static final String JSON_PROPERTY_GROUP = "group";
    private String group;
    public static final String JSON_PROPERTY_HISTORY = "history";
    private List<List<Double>> history = null;
    public static final String JSON_PROPERTY_MONITOR_MODIFIED = "monitor_modified";
    private Long monitorModified;
    public static final String JSON_PROPERTY_MONITOR_TYPE = "monitor_type";
    private String monitorType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRECISION = "precision";
    private Double precision;
    public static final String JSON_PROPERTY_PREVIEW = "preview";
    private Boolean preview;
    public static final String JSON_PROPERTY_SLI_VALUE = "sli_value";
    private JsonNullable<Double> sliValue = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SPAN_PRECISION = "span_precision";
    private Double spanPrecision;
    public static final String JSON_PROPERTY_UPTIME = "uptime";
    private Double uptime;
    private Map<String, Object> additionalProperties;

    public SLOHistoryMonitor errorBudgetRemaining(Map<String, Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
        return this;
    }

    public SLOHistoryMonitor putErrorBudgetRemainingItem(String key, Double errorBudgetRemainingItem) {
        if (this.errorBudgetRemaining == null) {
            this.errorBudgetRemaining = new HashMap<String, Double>();
        }
        this.errorBudgetRemaining.put(key, errorBudgetRemainingItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="error_budget_remaining")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getErrorBudgetRemaining() {
        return this.errorBudgetRemaining;
    }

    public void setErrorBudgetRemaining(Map<String, Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
    }

    public SLOHistoryMonitor errors(List<SLOHistoryResponseErrorWithType> errors) {
        this.errors = errors;
        for (SLOHistoryResponseErrorWithType item : errors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOHistoryMonitor addErrorsItem(SLOHistoryResponseErrorWithType errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<SLOHistoryResponseErrorWithType>();
        }
        this.errors.add(errorsItem);
        this.unparsed |= errorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SLOHistoryResponseErrorWithType> getErrors() {
        return this.errors;
    }

    public void setErrors(List<SLOHistoryResponseErrorWithType> errors) {
        this.errors = errors;
    }

    public SLOHistoryMonitor group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public SLOHistoryMonitor history(List<List<Double>> history) {
        this.history = history;
        return this;
    }

    public SLOHistoryMonitor addHistoryItem(List<Double> historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<List<Double>>();
        }
        this.history.add(historyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="history")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Double>> getHistory() {
        return this.history;
    }

    public void setHistory(List<List<Double>> history) {
        this.history = history;
    }

    public SLOHistoryMonitor monitorModified(Long monitorModified) {
        this.monitorModified = monitorModified;
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorModified() {
        return this.monitorModified;
    }

    public void setMonitorModified(Long monitorModified) {
        this.monitorModified = monitorModified;
    }

    public SLOHistoryMonitor monitorType(String monitorType) {
        this.monitorType = monitorType;
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    public SLOHistoryMonitor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SLOHistoryMonitor precision(Double precision) {
        this.precision = precision;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPrecision() {
        return this.precision;
    }

    @Deprecated
    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public SLOHistoryMonitor preview(Boolean preview) {
        this.preview = preview;
        return this;
    }

    @Nullable
    @JsonProperty(value="preview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreview() {
        return this.preview;
    }

    public void setPreview(Boolean preview) {
        this.preview = preview;
    }

    public SLOHistoryMonitor sliValue(Double sliValue) {
        this.sliValue = JsonNullable.of(sliValue);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Double getSliValue() {
        return this.sliValue.orElse(null);
    }

    @JsonProperty(value="sli_value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Double> getSliValue_JsonNullable() {
        return this.sliValue;
    }

    @JsonProperty(value="sli_value")
    public void setSliValue_JsonNullable(JsonNullable<Double> sliValue) {
        this.sliValue = sliValue;
    }

    public void setSliValue(Double sliValue) {
        this.sliValue = JsonNullable.of(sliValue);
    }

    public SLOHistoryMonitor spanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
        return this;
    }

    @Nullable
    @JsonProperty(value="span_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSpanPrecision() {
        return this.spanPrecision;
    }

    public void setSpanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
    }

    public SLOHistoryMonitor uptime(Double uptime) {
        this.uptime = uptime;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="uptime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUptime() {
        return this.uptime;
    }

    @Deprecated
    public void setUptime(Double uptime) {
        this.uptime = uptime;
    }

    @JsonAnySetter
    public SLOHistoryMonitor putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryMonitor sloHistoryMonitor = (SLOHistoryMonitor)o;
        return Objects.equals(this.errorBudgetRemaining, sloHistoryMonitor.errorBudgetRemaining) && Objects.equals(this.errors, sloHistoryMonitor.errors) && Objects.equals(this.group, sloHistoryMonitor.group) && Objects.equals(this.history, sloHistoryMonitor.history) && Objects.equals(this.monitorModified, sloHistoryMonitor.monitorModified) && Objects.equals(this.monitorType, sloHistoryMonitor.monitorType) && Objects.equals(this.name, sloHistoryMonitor.name) && Objects.equals(this.precision, sloHistoryMonitor.precision) && Objects.equals(this.preview, sloHistoryMonitor.preview) && Objects.equals(this.sliValue, sloHistoryMonitor.sliValue) && Objects.equals(this.spanPrecision, sloHistoryMonitor.spanPrecision) && Objects.equals(this.uptime, sloHistoryMonitor.uptime) && Objects.equals(this.additionalProperties, sloHistoryMonitor.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.errorBudgetRemaining, this.errors, this.group, this.history, this.monitorModified, this.monitorType, this.name, this.precision, this.preview, this.sliValue, this.spanPrecision, this.uptime, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryMonitor {\n");
        sb.append("    errorBudgetRemaining: ").append(this.toIndentedString(this.errorBudgetRemaining)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    monitorModified: ").append(this.toIndentedString(this.monitorModified)).append("\n");
        sb.append("    monitorType: ").append(this.toIndentedString(this.monitorType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    preview: ").append(this.toIndentedString(this.preview)).append("\n");
        sb.append("    sliValue: ").append(this.toIndentedString(this.sliValue)).append("\n");
        sb.append("    spanPrecision: ").append(this.toIndentedString(this.spanPrecision)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

