/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOHistoryResponseData;
import com.datadog.api.client.v1.model.SLOHistoryResponseError;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "errors"})
public class SLOHistoryResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private SLOHistoryResponseData data;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private JsonNullable<List<SLOHistoryResponseError>> errors = JsonNullable.undefined();
    private Map<String, Object> additionalProperties;

    public SLOHistoryResponse data(SLOHistoryResponseData data) {
        this.data = data;
        this.unparsed |= data.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOHistoryResponseData getData() {
        return this.data;
    }

    public void setData(SLOHistoryResponseData data) {
        this.data = data;
    }

    public SLOHistoryResponse errors(List<SLOHistoryResponseError> errors) {
        this.errors = JsonNullable.of(errors);
        return this;
    }

    public SLOHistoryResponse addErrorsItem(SLOHistoryResponseError errorsItem) {
        if (this.errors == null || !this.errors.isPresent()) {
            this.errors = JsonNullable.of(new ArrayList());
        }
        try {
            this.errors.get().add(errorsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<SLOHistoryResponseError> getErrors() {
        return this.errors.orElse(null);
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<SLOHistoryResponseError>> getErrors_JsonNullable() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    public void setErrors_JsonNullable(JsonNullable<List<SLOHistoryResponseError>> errors) {
        this.errors = errors;
    }

    public void setErrors(List<SLOHistoryResponseError> errors) {
        this.errors = JsonNullable.of(errors);
    }

    @JsonAnySetter
    public SLOHistoryResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryResponse sloHistoryResponse = (SLOHistoryResponse)o;
        return Objects.equals(this.data, sloHistoryResponse.data) && Objects.equals(this.errors, sloHistoryResponse.errors) && Objects.equals(this.additionalProperties, sloHistoryResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

