/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOHistoryMetrics;
import com.datadog.api.client.v1.model.SLOHistoryMonitor;
import com.datadog.api.client.v1.model.SLOHistorySLIData;
import com.datadog.api.client.v1.model.SLOThreshold;
import com.datadog.api.client.v1.model.SLOType;
import com.datadog.api.client.v1.model.SLOTypeNumeric;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"from_ts", "group_by", "groups", "monitors", "overall", "series", "thresholds", "to_ts", "type", "type_id"})
public class SLOHistoryResponseData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FROM_TS = "from_ts";
    private Long fromTs;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<String> groupBy = null;
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<SLOHistoryMonitor> groups = null;
    public static final String JSON_PROPERTY_MONITORS = "monitors";
    private List<SLOHistoryMonitor> monitors = null;
    public static final String JSON_PROPERTY_OVERALL = "overall";
    private SLOHistorySLIData overall;
    public static final String JSON_PROPERTY_SERIES = "series";
    private SLOHistoryMetrics series;
    public static final String JSON_PROPERTY_THRESHOLDS = "thresholds";
    private Map<String, SLOThreshold> thresholds = null;
    public static final String JSON_PROPERTY_TO_TS = "to_ts";
    private Long toTs;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SLOType type;
    public static final String JSON_PROPERTY_TYPE_ID = "type_id";
    private SLOTypeNumeric typeId;
    private Map<String, Object> additionalProperties;

    public SLOHistoryResponseData fromTs(Long fromTs) {
        this.fromTs = fromTs;
        return this;
    }

    @Nullable
    @JsonProperty(value="from_ts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFromTs() {
        return this.fromTs;
    }

    public void setFromTs(Long fromTs) {
        this.fromTs = fromTs;
    }

    public SLOHistoryResponseData groupBy(List<String> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public SLOHistoryResponseData addGroupByItem(String groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.add(groupByItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
    }

    public SLOHistoryResponseData groups(List<SLOHistoryMonitor> groups) {
        this.groups = groups;
        for (SLOHistoryMonitor item : groups) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOHistoryResponseData addGroupsItem(SLOHistoryMonitor groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<SLOHistoryMonitor>();
        }
        this.groups.add(groupsItem);
        this.unparsed |= groupsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SLOHistoryMonitor> getGroups() {
        return this.groups;
    }

    public void setGroups(List<SLOHistoryMonitor> groups) {
        this.groups = groups;
    }

    public SLOHistoryResponseData monitors(List<SLOHistoryMonitor> monitors) {
        this.monitors = monitors;
        for (SLOHistoryMonitor item : monitors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOHistoryResponseData addMonitorsItem(SLOHistoryMonitor monitorsItem) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<SLOHistoryMonitor>();
        }
        this.monitors.add(monitorsItem);
        this.unparsed |= monitorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="monitors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SLOHistoryMonitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<SLOHistoryMonitor> monitors) {
        this.monitors = monitors;
    }

    public SLOHistoryResponseData overall(SLOHistorySLIData overall) {
        this.overall = overall;
        this.unparsed |= overall.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="overall")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOHistorySLIData getOverall() {
        return this.overall;
    }

    public void setOverall(SLOHistorySLIData overall) {
        this.overall = overall;
    }

    public SLOHistoryResponseData series(SLOHistoryMetrics series) {
        this.series = series;
        this.unparsed |= series.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOHistoryMetrics getSeries() {
        return this.series;
    }

    public void setSeries(SLOHistoryMetrics series) {
        this.series = series;
    }

    public SLOHistoryResponseData thresholds(Map<String, SLOThreshold> thresholds) {
        this.thresholds = thresholds;
        return this;
    }

    public SLOHistoryResponseData putThresholdsItem(String key, SLOThreshold thresholdsItem) {
        if (this.thresholds == null) {
            this.thresholds = new HashMap<String, SLOThreshold>();
        }
        this.thresholds.put(key, thresholdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="thresholds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SLOThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Map<String, SLOThreshold> thresholds) {
        this.thresholds = thresholds;
    }

    public SLOHistoryResponseData toTs(Long toTs) {
        this.toTs = toTs;
        return this;
    }

    @Nullable
    @JsonProperty(value="to_ts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getToTs() {
        return this.toTs;
    }

    public void setToTs(Long toTs) {
        this.toTs = toTs;
    }

    public SLOHistoryResponseData type(SLOType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOType getType() {
        return this.type;
    }

    public void setType(SLOType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public SLOHistoryResponseData typeId(SLOTypeNumeric typeId) {
        this.typeId = typeId;
        this.unparsed |= !typeId.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOTypeNumeric getTypeId() {
        return this.typeId;
    }

    public void setTypeId(SLOTypeNumeric typeId) {
        if (!typeId.isValid()) {
            this.unparsed = true;
        }
        this.typeId = typeId;
    }

    @JsonAnySetter
    public SLOHistoryResponseData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryResponseData sloHistoryResponseData = (SLOHistoryResponseData)o;
        return Objects.equals(this.fromTs, sloHistoryResponseData.fromTs) && Objects.equals(this.groupBy, sloHistoryResponseData.groupBy) && Objects.equals(this.groups, sloHistoryResponseData.groups) && Objects.equals(this.monitors, sloHistoryResponseData.monitors) && Objects.equals(this.overall, sloHistoryResponseData.overall) && Objects.equals(this.series, sloHistoryResponseData.series) && Objects.equals(this.thresholds, sloHistoryResponseData.thresholds) && Objects.equals(this.toTs, sloHistoryResponseData.toTs) && Objects.equals(this.type, sloHistoryResponseData.type) && Objects.equals(this.typeId, sloHistoryResponseData.typeId) && Objects.equals(this.additionalProperties, sloHistoryResponseData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fromTs, this.groupBy, this.groups, this.monitors, this.overall, this.series, this.thresholds, this.toTs, this.type, this.typeId, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryResponseData {\n");
        sb.append("    fromTs: ").append(this.toIndentedString(this.fromTs)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    overall: ").append(this.toIndentedString(this.overall)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    toTs: ").append(this.toIndentedString(this.toTs)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

