/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.client.v1.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.client.v1.model.ScatterplotWidgetFormula;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"formulas", "queries", "response_format"})
public class ScatterplotTableRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<ScatterplotWidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;
    private Map<String, Object> additionalProperties;

    public ScatterplotTableRequest formulas(List<ScatterplotWidgetFormula> formulas) {
        this.formulas = formulas;
        for (ScatterplotWidgetFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScatterplotTableRequest addFormulasItem(ScatterplotWidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<ScatterplotWidgetFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScatterplotWidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<ScatterplotWidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public ScatterplotTableRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        for (FormulaAndFunctionQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScatterplotTableRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public ScatterplotTableRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    @JsonAnySetter
    public ScatterplotTableRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScatterplotTableRequest scatterplotTableRequest = (ScatterplotTableRequest)o;
        return Objects.equals(this.formulas, scatterplotTableRequest.formulas) && Objects.equals(this.queries, scatterplotTableRequest.queries) && Objects.equals(this.responseFormat, scatterplotTableRequest.responseFormat) && Objects.equals(this.additionalProperties, scatterplotTableRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.formulas, this.queries, this.responseFormat, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScatterplotTableRequest {\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

