/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonPropertyOrder(value={"denominator", "metrics", "numerator"})
public class SearchSLOQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DENOMINATOR = "denominator";
    private String denominator;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private JsonNullable<List<String>> metrics = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NUMERATOR = "numerator";
    private String numerator;
    private Map<String, Object> additionalProperties;

    public SearchSLOQuery denominator(String denominator) {
        this.denominator = denominator;
        return this;
    }

    @Nullable
    @JsonProperty(value="denominator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDenominator() {
        return this.denominator;
    }

    public void setDenominator(String denominator) {
        this.denominator = denominator;
    }

    public SearchSLOQuery metrics(List<String> metrics) {
        this.metrics = JsonNullable.of(metrics);
        return this;
    }

    public SearchSLOQuery addMetricsItem(String metricsItem) {
        if (this.metrics == null || !this.metrics.isPresent()) {
            this.metrics = JsonNullable.of(new ArrayList());
        }
        try {
            this.metrics.get().add(metricsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getMetrics() {
        return this.metrics.orElse(null);
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getMetrics_JsonNullable() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetrics_JsonNullable(JsonNullable<List<String>> metrics) {
        this.metrics = metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = JsonNullable.of(metrics);
    }

    public SearchSLOQuery numerator(String numerator) {
        this.numerator = numerator;
        return this;
    }

    @Nullable
    @JsonProperty(value="numerator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumerator() {
        return this.numerator;
    }

    public void setNumerator(String numerator) {
        this.numerator = numerator;
    }

    @JsonAnySetter
    public SearchSLOQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSLOQuery searchSloQuery = (SearchSLOQuery)o;
        return Objects.equals(this.denominator, searchSloQuery.denominator) && Objects.equals(this.metrics, searchSloQuery.metrics) && Objects.equals(this.numerator, searchSloQuery.numerator) && Objects.equals(this.additionalProperties, searchSloQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.denominator, this.metrics, this.numerator, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchSLOQuery {\n");
        sb.append("    denominator: ").append(this.toIndentedString(this.denominator)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    numerator: ").append(this.toIndentedString(this.numerator)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

