/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.WebhooksIntegrationEncoding;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"custom_headers", "encode_as", "name", "payload", "url"})
public class WebhooksIntegration {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_HEADERS = "custom_headers";
    private JsonNullable<String> customHeaders = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ENCODE_AS = "encode_as";
    private WebhooksIntegrationEncoding encodeAs = WebhooksIntegrationEncoding.JSON;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private JsonNullable<String> payload = JsonNullable.undefined();
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private Map<String, Object> additionalProperties;

    public WebhooksIntegration() {
    }

    @JsonCreator
    public WebhooksIntegration(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="url") String url) {
        this.name = name;
        this.url = url;
    }

    public WebhooksIntegration customHeaders(String customHeaders) {
        this.customHeaders = JsonNullable.of(customHeaders);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getCustomHeaders() {
        return this.customHeaders.orElse(null);
    }

    @JsonProperty(value="custom_headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomHeaders_JsonNullable() {
        return this.customHeaders;
    }

    @JsonProperty(value="custom_headers")
    public void setCustomHeaders_JsonNullable(JsonNullable<String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void setCustomHeaders(String customHeaders) {
        this.customHeaders = JsonNullable.of(customHeaders);
    }

    public WebhooksIntegration encodeAs(WebhooksIntegrationEncoding encodeAs) {
        this.encodeAs = encodeAs;
        this.unparsed |= !encodeAs.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="encode_as")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebhooksIntegrationEncoding getEncodeAs() {
        return this.encodeAs;
    }

    public void setEncodeAs(WebhooksIntegrationEncoding encodeAs) {
        if (!encodeAs.isValid()) {
            this.unparsed = true;
        }
        this.encodeAs = encodeAs;
    }

    public WebhooksIntegration name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebhooksIntegration payload(String payload) {
        this.payload = JsonNullable.of(payload);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getPayload() {
        return this.payload.orElse(null);
    }

    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPayload_JsonNullable() {
        return this.payload;
    }

    @JsonProperty(value="payload")
    public void setPayload_JsonNullable(JsonNullable<String> payload) {
        this.payload = payload;
    }

    public void setPayload(String payload) {
        this.payload = JsonNullable.of(payload);
    }

    public WebhooksIntegration url(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonAnySetter
    public WebhooksIntegration putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhooksIntegration webhooksIntegration = (WebhooksIntegration)o;
        return Objects.equals(this.customHeaders, webhooksIntegration.customHeaders) && Objects.equals(this.encodeAs, webhooksIntegration.encodeAs) && Objects.equals(this.name, webhooksIntegration.name) && Objects.equals(this.payload, webhooksIntegration.payload) && Objects.equals(this.url, webhooksIntegration.url) && Objects.equals(this.additionalProperties, webhooksIntegration.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.customHeaders, this.encodeAs, this.name, this.payload, this.url, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhooksIntegration {\n");
        sb.append("    customHeaders: ").append(this.toIndentedString(this.customHeaders)).append("\n");
        sb.append("    encodeAs: ").append(this.toIndentedString(this.encodeAs)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

