/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.RUMAggregateRequest;
import com.datadog.api.client.v2.model.RUMAnalyticsAggregateResponse;
import com.datadog.api.client.v2.model.RUMApplicationCreateRequest;
import com.datadog.api.client.v2.model.RUMApplicationResponse;
import com.datadog.api.client.v2.model.RUMApplicationUpdateRequest;
import com.datadog.api.client.v2.model.RUMApplicationsResponse;
import com.datadog.api.client.v2.model.RUMEvent;
import com.datadog.api.client.v2.model.RUMEventsResponse;
import com.datadog.api.client.v2.model.RUMQueryPageOptions;
import com.datadog.api.client.v2.model.RUMSearchEventsRequest;
import com.datadog.api.client.v2.model.RUMSort;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class RumApi {
    private ApiClient apiClient;

    public RumApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public RumApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RUMAnalyticsAggregateResponse aggregateRUMEvents(RUMAggregateRequest body) throws ApiException {
        return this.aggregateRUMEventsWithHttpInfo(body).getData();
    }

    public CompletableFuture<RUMAnalyticsAggregateResponse> aggregateRUMEventsAsync(RUMAggregateRequest body) {
        return this.aggregateRUMEventsWithHttpInfoAsync(body).thenApply(response -> (RUMAnalyticsAggregateResponse)response.getData());
    }

    public ApiResponse<RUMAnalyticsAggregateResponse> aggregateRUMEventsWithHttpInfo(RUMAggregateRequest body) throws ApiException {
        RUMAggregateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling aggregateRUMEvents");
        }
        String localVarPath = "/api/v2/rum/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.aggregateRUMEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMAnalyticsAggregateResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMAnalyticsAggregateResponse>> aggregateRUMEventsWithHttpInfoAsync(RUMAggregateRequest body) {
        Invocation.Builder builder;
        RUMAggregateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RUMAnalyticsAggregateResponse>> result = new CompletableFuture<ApiResponse<RUMAnalyticsAggregateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling aggregateRUMEvents"));
            return result;
        }
        String localVarPath = "/api/v2/rum/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.aggregateRUMEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMAnalyticsAggregateResponse>> result = new CompletableFuture<ApiResponse<RUMAnalyticsAggregateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMAnalyticsAggregateResponse>(){});
    }

    public RUMApplicationResponse createRUMApplication(RUMApplicationCreateRequest body) throws ApiException {
        return this.createRUMApplicationWithHttpInfo(body).getData();
    }

    public CompletableFuture<RUMApplicationResponse> createRUMApplicationAsync(RUMApplicationCreateRequest body) {
        return this.createRUMApplicationWithHttpInfoAsync(body).thenApply(response -> (RUMApplicationResponse)response.getData());
    }

    public ApiResponse<RUMApplicationResponse> createRUMApplicationWithHttpInfo(RUMApplicationCreateRequest body) throws ApiException {
        RUMApplicationCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRUMApplication");
        }
        String localVarPath = "/api/v2/rum/applications";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.createRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMApplicationResponse>> createRUMApplicationWithHttpInfoAsync(RUMApplicationCreateRequest body) {
        Invocation.Builder builder;
        RUMApplicationCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createRUMApplication"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.createRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationResponse>(){});
    }

    public void deleteRUMApplication(String id) throws ApiException {
        this.deleteRUMApplicationWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteRUMApplicationAsync(String id) {
        return this.deleteRUMApplicationWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteRUMApplicationWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteRUMApplication");
        }
        String localVarPath = "/api/v2/rum/applications/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.deleteRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRUMApplicationWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteRUMApplication"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.deleteRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RUMApplicationResponse getRUMApplication(String id) throws ApiException {
        return this.getRUMApplicationWithHttpInfo(id).getData();
    }

    public CompletableFuture<RUMApplicationResponse> getRUMApplicationAsync(String id) {
        return this.getRUMApplicationWithHttpInfoAsync(id).thenApply(response -> (RUMApplicationResponse)response.getData());
    }

    public ApiResponse<RUMApplicationResponse> getRUMApplicationWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRUMApplication");
        }
        String localVarPath = "/api/v2/rum/applications/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.getRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMApplicationResponse>> getRUMApplicationWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getRUMApplication"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.getRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationResponse>(){});
    }

    public RUMApplicationsResponse getRUMApplications() throws ApiException {
        return this.getRUMApplicationsWithHttpInfo().getData();
    }

    public CompletableFuture<RUMApplicationsResponse> getRUMApplicationsAsync() {
        return this.getRUMApplicationsWithHttpInfoAsync().thenApply(response -> (RUMApplicationsResponse)response.getData());
    }

    public ApiResponse<RUMApplicationsResponse> getRUMApplicationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/rum/applications";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.getRUMApplications", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMApplicationsResponse>> getRUMApplicationsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/rum/applications";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.getRUMApplications", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMApplicationsResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationsResponse>(){});
    }

    public RUMEventsResponse listRUMEvents() throws ApiException {
        return this.listRUMEventsWithHttpInfo(new ListRUMEventsOptionalParameters()).getData();
    }

    public CompletableFuture<RUMEventsResponse> listRUMEventsAsync() {
        return this.listRUMEventsWithHttpInfoAsync(new ListRUMEventsOptionalParameters()).thenApply(response -> (RUMEventsResponse)response.getData());
    }

    public RUMEventsResponse listRUMEvents(ListRUMEventsOptionalParameters parameters) throws ApiException {
        return this.listRUMEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<RUMEventsResponse> listRUMEventsAsync(ListRUMEventsOptionalParameters parameters) {
        return this.listRUMEventsWithHttpInfoAsync(parameters).thenApply(response -> (RUMEventsResponse)response.getData());
    }

    public PaginationIterable<RUMEvent> listRUMEventsWithPagination() {
        ListRUMEventsOptionalParameters parameters = new ListRUMEventsOptionalParameters();
        return this.listRUMEventsWithPagination(parameters);
    }

    public PaginationIterable<RUMEvent> listRUMEventsWithPagination(ListRUMEventsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<RUMEvent> iterator = new PaginationIterable<RUMEvent>(this, "listRUMEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<RUMEventsResponse> listRUMEventsWithHttpInfo(ListRUMEventsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        RUMSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/rum/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.listRUMEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMEventsResponse>> listRUMEventsWithHttpInfoAsync(ListRUMEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        RUMSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/rum/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.listRUMEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMEventsResponse>> result = new CompletableFuture<ApiResponse<RUMEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMEventsResponse>(){});
    }

    public RUMEventsResponse searchRUMEvents(RUMSearchEventsRequest body) throws ApiException {
        return this.searchRUMEventsWithHttpInfo(body).getData();
    }

    public CompletableFuture<RUMEventsResponse> searchRUMEventsAsync(RUMSearchEventsRequest body) {
        return this.searchRUMEventsWithHttpInfoAsync(body).thenApply(response -> (RUMEventsResponse)response.getData());
    }

    public PaginationIterable<RUMEvent> searchRUMEventsWithPagination(RUMSearchEventsRequest body) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = false;
        if (body.getPage() == null) {
            body.setPage(new RUMQueryPageOptions());
        }
        if (body.getPage().getLimit() == null) {
            limit = 10;
            body.getPage().setLimit(limit);
        } else {
            limit = body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("body", body);
        PaginationIterable<RUMEvent> iterator = new PaginationIterable<RUMEvent>(this, "searchRUMEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<RUMEventsResponse> searchRUMEventsWithHttpInfo(RUMSearchEventsRequest body) throws ApiException {
        RUMSearchEventsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling searchRUMEvents");
        }
        String localVarPath = "/api/v2/rum/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.searchRUMEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMEventsResponse>> searchRUMEventsWithHttpInfoAsync(RUMSearchEventsRequest body) {
        Invocation.Builder builder;
        RUMSearchEventsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RUMEventsResponse>> result = new CompletableFuture<ApiResponse<RUMEventsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling searchRUMEvents"));
            return result;
        }
        String localVarPath = "/api/v2/rum/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.searchRUMEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMEventsResponse>> result = new CompletableFuture<ApiResponse<RUMEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMEventsResponse>(){});
    }

    public RUMApplicationResponse updateRUMApplication(String id, RUMApplicationUpdateRequest body) throws ApiException {
        return this.updateRUMApplicationWithHttpInfo(id, body).getData();
    }

    public CompletableFuture<RUMApplicationResponse> updateRUMApplicationAsync(String id, RUMApplicationUpdateRequest body) {
        return this.updateRUMApplicationWithHttpInfoAsync(id, body).thenApply(response -> (RUMApplicationResponse)response.getData());
    }

    public ApiResponse<RUMApplicationResponse> updateRUMApplicationWithHttpInfo(String id, RUMApplicationUpdateRequest body) throws ApiException {
        RUMApplicationUpdateRequest localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateRUMApplication");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRUMApplication");
        }
        String localVarPath = "/api/v2/rum/applications/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumApi.updateRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationResponse>(){});
    }

    public CompletableFuture<ApiResponse<RUMApplicationResponse>> updateRUMApplicationWithHttpInfoAsync(String id, RUMApplicationUpdateRequest body) {
        Invocation.Builder builder;
        RUMApplicationUpdateRequest localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateRUMApplication"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateRUMApplication"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumApi.updateRUMApplication", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RUMApplicationResponse>> result = new CompletableFuture<ApiResponse<RUMApplicationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RUMApplicationResponse>(){});
    }

    public static class ListRUMEventsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private RUMSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListRUMEventsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListRUMEventsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListRUMEventsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListRUMEventsOptionalParameters sort(RUMSort sort) {
            this.sort = sort;
            return this;
        }

        public ListRUMEventsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListRUMEventsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }
}

