/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ServiceDefinitionCreateResponse;
import com.datadog.api.client.v2.model.ServiceDefinitionData;
import com.datadog.api.client.v2.model.ServiceDefinitionGetResponse;
import com.datadog.api.client.v2.model.ServiceDefinitionSchemaVersions;
import com.datadog.api.client.v2.model.ServiceDefinitionsCreateRequest;
import com.datadog.api.client.v2.model.ServiceDefinitionsListResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class ServiceDefinitionApi {
    private ApiClient apiClient;

    public ServiceDefinitionApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ServiceDefinitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ServiceDefinitionCreateResponse createOrUpdateServiceDefinitions(ServiceDefinitionsCreateRequest body) throws ApiException {
        return this.createOrUpdateServiceDefinitionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<ServiceDefinitionCreateResponse> createOrUpdateServiceDefinitionsAsync(ServiceDefinitionsCreateRequest body) {
        return this.createOrUpdateServiceDefinitionsWithHttpInfoAsync(body).thenApply(response -> (ServiceDefinitionCreateResponse)response.getData());
    }

    public ApiResponse<ServiceDefinitionCreateResponse> createOrUpdateServiceDefinitionsWithHttpInfo(ServiceDefinitionsCreateRequest body) throws ApiException {
        ServiceDefinitionsCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOrUpdateServiceDefinitions");
        }
        String localVarPath = "/api/v2/services/definitions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.createOrUpdateServiceDefinitions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>> createOrUpdateServiceDefinitionsWithHttpInfoAsync(ServiceDefinitionsCreateRequest body) {
        Invocation.Builder builder;
        ServiceDefinitionsCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOrUpdateServiceDefinitions"));
            return result;
        }
        String localVarPath = "/api/v2/services/definitions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.createOrUpdateServiceDefinitions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionCreateResponse>(){});
    }

    public void deleteServiceDefinition(String serviceName) throws ApiException {
        this.deleteServiceDefinitionWithHttpInfo(serviceName);
    }

    public CompletableFuture<Void> deleteServiceDefinitionAsync(String serviceName) {
        return this.deleteServiceDefinitionWithHttpInfoAsync(serviceName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteServiceDefinitionWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling deleteServiceDefinition");
        }
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.deleteServiceDefinition", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteServiceDefinitionWithHttpInfoAsync(String serviceName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling deleteServiceDefinition"));
            return result;
        }
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.deleteServiceDefinition", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ServiceDefinitionGetResponse getServiceDefinition(String serviceName) throws ApiException {
        return this.getServiceDefinitionWithHttpInfo(serviceName, new GetServiceDefinitionOptionalParameters()).getData();
    }

    public CompletableFuture<ServiceDefinitionGetResponse> getServiceDefinitionAsync(String serviceName) {
        return this.getServiceDefinitionWithHttpInfoAsync(serviceName, new GetServiceDefinitionOptionalParameters()).thenApply(response -> (ServiceDefinitionGetResponse)response.getData());
    }

    public ServiceDefinitionGetResponse getServiceDefinition(String serviceName, GetServiceDefinitionOptionalParameters parameters) throws ApiException {
        return this.getServiceDefinitionWithHttpInfo(serviceName, parameters).getData();
    }

    public CompletableFuture<ServiceDefinitionGetResponse> getServiceDefinitionAsync(String serviceName, GetServiceDefinitionOptionalParameters parameters) {
        return this.getServiceDefinitionWithHttpInfoAsync(serviceName, parameters).thenApply(response -> (ServiceDefinitionGetResponse)response.getData());
    }

    public ApiResponse<ServiceDefinitionGetResponse> getServiceDefinitionWithHttpInfo(String serviceName, GetServiceDefinitionOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling getServiceDefinition");
        }
        ServiceDefinitionSchemaVersions schemaVersion = parameters.schemaVersion;
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "schema_version", schemaVersion));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.getServiceDefinition", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>> getServiceDefinitionWithHttpInfoAsync(String serviceName, GetServiceDefinitionOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling getServiceDefinition"));
            return result;
        }
        ServiceDefinitionSchemaVersions schemaVersion = parameters.schemaVersion;
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "schema_version", schemaVersion));
        try {
            builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.getServiceDefinition", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionGetResponse>(){});
    }

    public ServiceDefinitionsListResponse listServiceDefinitions() throws ApiException {
        return this.listServiceDefinitionsWithHttpInfo(new ListServiceDefinitionsOptionalParameters()).getData();
    }

    public CompletableFuture<ServiceDefinitionsListResponse> listServiceDefinitionsAsync() {
        return this.listServiceDefinitionsWithHttpInfoAsync(new ListServiceDefinitionsOptionalParameters()).thenApply(response -> (ServiceDefinitionsListResponse)response.getData());
    }

    public ServiceDefinitionsListResponse listServiceDefinitions(ListServiceDefinitionsOptionalParameters parameters) throws ApiException {
        return this.listServiceDefinitionsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ServiceDefinitionsListResponse> listServiceDefinitionsAsync(ListServiceDefinitionsOptionalParameters parameters) {
        return this.listServiceDefinitionsWithHttpInfoAsync(parameters).thenApply(response -> (ServiceDefinitionsListResponse)response.getData());
    }

    public PaginationIterable<ServiceDefinitionData> listServiceDefinitionsWithPagination() {
        ListServiceDefinitionsOptionalParameters parameters = new ListServiceDefinitionsOptionalParameters();
        return this.listServiceDefinitionsWithPagination(parameters);
    }

    public PaginationIterable<ServiceDefinitionData> listServiceDefinitionsWithPagination(ListServiceDefinitionsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageNumber";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<ServiceDefinitionData> iterator = new PaginationIterable<ServiceDefinitionData>(this, "listServiceDefinitions", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<ServiceDefinitionsListResponse> listServiceDefinitionsWithHttpInfo(ListServiceDefinitionsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ServiceDefinitionSchemaVersions schemaVersion = parameters.schemaVersion;
        String localVarPath = "/api/v2/services/definitions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "schema_version", schemaVersion));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.listServiceDefinitions", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<ServiceDefinitionsListResponse>> listServiceDefinitionsWithHttpInfoAsync(ListServiceDefinitionsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ServiceDefinitionSchemaVersions schemaVersion = parameters.schemaVersion;
        String localVarPath = "/api/v2/services/definitions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "schema_version", schemaVersion));
        try {
            builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.listServiceDefinitions", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ServiceDefinitionsListResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionsListResponse>(){});
    }

    public static class ListServiceDefinitionsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ServiceDefinitionSchemaVersions schemaVersion;

        public ListServiceDefinitionsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListServiceDefinitionsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListServiceDefinitionsOptionalParameters schemaVersion(ServiceDefinitionSchemaVersions schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }
    }

    public static class GetServiceDefinitionOptionalParameters {
        private ServiceDefinitionSchemaVersions schemaVersion;

        public GetServiceDefinitionOptionalParameters schemaVersion(ServiceDefinitionSchemaVersions schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }
    }
}

