/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Creator;
import com.datadog.api.client.v2.model.DashboardType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"author", "created", "icon", "id", "integration_id", "is_favorite", "is_read_only", "is_shared", "modified", "popularity", "title", "type", "url"})
public class DashboardListItem {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private Creator author;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ICON = "icon";
    private JsonNullable<String> icon = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integration_id";
    private JsonNullable<String> integrationId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IS_FAVORITE = "is_favorite";
    private Boolean isFavorite;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly;
    public static final String JSON_PROPERTY_IS_SHARED = "is_shared";
    private Boolean isShared;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_POPULARITY = "popularity";
    private Integer popularity;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DashboardType type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private Map<String, Object> additionalProperties;

    public DashboardListItem() {
    }

    @JsonCreator
    public DashboardListItem(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") DashboardType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public DashboardListItem author(Creator author) {
        this.author = author;
        this.unparsed |= author.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getAuthor() {
        return this.author;
    }

    public void setAuthor(Creator author) {
        this.author = author;
    }

    @Nullable
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @JsonIgnore
    public String getIcon() {
        if (this.icon == null) {
            this.icon = JsonNullable.undefined();
        }
        return this.icon.orElse(null);
    }

    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIcon_JsonNullable() {
        return this.icon;
    }

    @JsonProperty(value="icon")
    private void setIcon_JsonNullable(JsonNullable<String> icon) {
        this.icon = icon;
    }

    public DashboardListItem id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @JsonIgnore
    public String getIntegrationId() {
        if (this.integrationId == null) {
            this.integrationId = JsonNullable.undefined();
        }
        return this.integrationId.orElse(null);
    }

    @JsonProperty(value="integration_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIntegrationId_JsonNullable() {
        return this.integrationId;
    }

    @JsonProperty(value="integration_id")
    private void setIntegrationId_JsonNullable(JsonNullable<String> integrationId) {
        this.integrationId = integrationId;
    }

    @Nullable
    @JsonProperty(value="is_favorite")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    @Nullable
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    @Nullable
    @JsonProperty(value="is_shared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsShared() {
        return this.isShared;
    }

    @Nullable
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    @Nullable
    @JsonProperty(value="popularity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPopularity() {
        return this.popularity;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public DashboardListItem type(DashboardType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DashboardType getType() {
        return this.type;
    }

    public void setType(DashboardType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @Nullable
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonAnySetter
    public DashboardListItem putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardListItem dashboardListItem = (DashboardListItem)o;
        return Objects.equals(this.author, dashboardListItem.author) && Objects.equals(this.created, dashboardListItem.created) && Objects.equals(this.icon, dashboardListItem.icon) && Objects.equals(this.id, dashboardListItem.id) && Objects.equals(this.integrationId, dashboardListItem.integrationId) && Objects.equals(this.isFavorite, dashboardListItem.isFavorite) && Objects.equals(this.isReadOnly, dashboardListItem.isReadOnly) && Objects.equals(this.isShared, dashboardListItem.isShared) && Objects.equals(this.modified, dashboardListItem.modified) && Objects.equals(this.popularity, dashboardListItem.popularity) && Objects.equals(this.title, dashboardListItem.title) && Objects.equals(this.type, dashboardListItem.type) && Objects.equals(this.url, dashboardListItem.url) && Objects.equals(this.additionalProperties, dashboardListItem.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.created, this.icon, this.id, this.integrationId, this.isFavorite, this.isReadOnly, this.isShared, this.modified, this.popularity, this.title, this.type, this.url, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardListItem {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    isFavorite: ").append(this.toIndentedString(this.isFavorite)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    isShared: ").append(this.toIndentedString(this.isShared)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    popularity: ").append(this.toIndentedString(this.popularity)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

