/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Event;
import com.datadog.api.client.v2.model.EventPriority;
import com.datadog.api.client.v2.model.EventStatusType;
import com.datadog.api.client.v2.model.MonitorType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation_key", "date_happened", "device_name", "duration", "event_object", "evt", "hostname", "monitor", "monitor_groups", "monitor_id", "priority", "related_event_id", "service", "source_type_name", "sourcecategory", "status", "tags", "timestamp", "title"})
public class EventAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION_KEY = "aggregation_key";
    private String aggregationKey;
    public static final String JSON_PROPERTY_DATE_HAPPENED = "date_happened";
    private Long dateHappened;
    public static final String JSON_PROPERTY_DEVICE_NAME = "device_name";
    private String deviceName;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Long duration;
    public static final String JSON_PROPERTY_EVENT_OBJECT = "event_object";
    private String eventObject;
    public static final String JSON_PROPERTY_EVT = "evt";
    private Event evt;
    public static final String JSON_PROPERTY_HOSTNAME = "hostname";
    private String hostname;
    public static final String JSON_PROPERTY_MONITOR = "monitor";
    private JsonNullable<MonitorType> monitor = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MONITOR_GROUPS = "monitor_groups";
    private JsonNullable<List<String>> monitorGroups = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MONITOR_ID = "monitor_id";
    private JsonNullable<Long> monitorId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private JsonNullable<EventPriority> priority = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RELATED_EVENT_ID = "related_event_id";
    private Long relatedEventId;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_SOURCE_TYPE_NAME = "source_type_name";
    private String sourceTypeName;
    public static final String JSON_PROPERTY_SOURCECATEGORY = "sourcecategory";
    private String sourcecategory;
    public static final String JSON_PROPERTY_STATUS = "status";
    private EventStatusType status;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    private Map<String, Object> additionalProperties;

    public EventAttributes aggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggregationKey() {
        return this.aggregationKey;
    }

    public void setAggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
    }

    public EventAttributes dateHappened(Long dateHappened) {
        this.dateHappened = dateHappened;
        return this;
    }

    @Nullable
    @JsonProperty(value="date_happened")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDateHappened() {
        return this.dateHappened;
    }

    public void setDateHappened(Long dateHappened) {
        this.dateHappened = dateHappened;
    }

    public EventAttributes deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Nullable
    @JsonProperty(value="device_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public EventAttributes duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public EventAttributes eventObject(String eventObject) {
        this.eventObject = eventObject;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_object")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventObject() {
        return this.eventObject;
    }

    public void setEventObject(String eventObject) {
        this.eventObject = eventObject;
    }

    public EventAttributes evt(Event evt) {
        this.evt = evt;
        this.unparsed |= evt.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="evt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Event getEvt() {
        return this.evt;
    }

    public void setEvt(Event evt) {
        this.evt = evt;
    }

    public EventAttributes hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @JsonProperty(value="hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public EventAttributes monitor(MonitorType monitor) {
        this.monitor = JsonNullable.of(monitor);
        return this;
    }

    @Nullable
    @JsonIgnore
    public MonitorType getMonitor() {
        return this.monitor.orElse(null);
    }

    @JsonProperty(value="monitor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<MonitorType> getMonitor_JsonNullable() {
        return this.monitor;
    }

    @JsonProperty(value="monitor")
    public void setMonitor_JsonNullable(JsonNullable<MonitorType> monitor) {
        this.monitor = monitor;
    }

    public void setMonitor(MonitorType monitor) {
        this.monitor = JsonNullable.of(monitor);
    }

    public EventAttributes monitorGroups(List<String> monitorGroups) {
        this.monitorGroups = JsonNullable.of(monitorGroups);
        return this;
    }

    public EventAttributes addMonitorGroupsItem(String monitorGroupsItem) {
        if (this.monitorGroups == null || !this.monitorGroups.isPresent()) {
            this.monitorGroups = JsonNullable.of(new ArrayList());
        }
        try {
            this.monitorGroups.get().add(monitorGroupsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getMonitorGroups() {
        return this.monitorGroups.orElse(null);
    }

    @JsonProperty(value="monitor_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getMonitorGroups_JsonNullable() {
        return this.monitorGroups;
    }

    @JsonProperty(value="monitor_groups")
    public void setMonitorGroups_JsonNullable(JsonNullable<List<String>> monitorGroups) {
        this.monitorGroups = monitorGroups;
    }

    public void setMonitorGroups(List<String> monitorGroups) {
        this.monitorGroups = JsonNullable.of(monitorGroups);
    }

    public EventAttributes monitorId(Long monitorId) {
        this.monitorId = JsonNullable.of(monitorId);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getMonitorId() {
        return this.monitorId.orElse(null);
    }

    @JsonProperty(value="monitor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getMonitorId_JsonNullable() {
        return this.monitorId;
    }

    @JsonProperty(value="monitor_id")
    public void setMonitorId_JsonNullable(JsonNullable<Long> monitorId) {
        this.monitorId = monitorId;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = JsonNullable.of(monitorId);
    }

    public EventAttributes priority(EventPriority priority) {
        this.priority = JsonNullable.of(priority);
        return this;
    }

    @Nullable
    @JsonIgnore
    public EventPriority getPriority() {
        return this.priority.orElse(null);
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<EventPriority> getPriority_JsonNullable() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority_JsonNullable(JsonNullable<EventPriority> priority) {
        this.priority = priority;
    }

    public void setPriority(EventPriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = JsonNullable.of(priority);
    }

    public EventAttributes relatedEventId(Long relatedEventId) {
        this.relatedEventId = relatedEventId;
        return this;
    }

    @Nullable
    @JsonProperty(value="related_event_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRelatedEventId() {
        return this.relatedEventId;
    }

    public void setRelatedEventId(Long relatedEventId) {
        this.relatedEventId = relatedEventId;
    }

    public EventAttributes service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public EventAttributes sourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_type_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public EventAttributes sourcecategory(String sourcecategory) {
        this.sourcecategory = sourcecategory;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourcecategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourcecategory() {
        return this.sourcecategory;
    }

    public void setSourcecategory(String sourcecategory) {
        this.sourcecategory = sourcecategory;
    }

    public EventAttributes status(EventStatusType status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventStatusType getStatus() {
        return this.status;
    }

    public void setStatus(EventStatusType status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public EventAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EventAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public EventAttributes timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public EventAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnySetter
    public EventAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventAttributes eventAttributes = (EventAttributes)o;
        return Objects.equals(this.aggregationKey, eventAttributes.aggregationKey) && Objects.equals(this.dateHappened, eventAttributes.dateHappened) && Objects.equals(this.deviceName, eventAttributes.deviceName) && Objects.equals(this.duration, eventAttributes.duration) && Objects.equals(this.eventObject, eventAttributes.eventObject) && Objects.equals(this.evt, eventAttributes.evt) && Objects.equals(this.hostname, eventAttributes.hostname) && Objects.equals(this.monitor, eventAttributes.monitor) && Objects.equals(this.monitorGroups, eventAttributes.monitorGroups) && Objects.equals(this.monitorId, eventAttributes.monitorId) && Objects.equals(this.priority, eventAttributes.priority) && Objects.equals(this.relatedEventId, eventAttributes.relatedEventId) && Objects.equals(this.service, eventAttributes.service) && Objects.equals(this.sourceTypeName, eventAttributes.sourceTypeName) && Objects.equals(this.sourcecategory, eventAttributes.sourcecategory) && Objects.equals(this.status, eventAttributes.status) && Objects.equals(this.tags, eventAttributes.tags) && Objects.equals(this.timestamp, eventAttributes.timestamp) && Objects.equals(this.title, eventAttributes.title) && Objects.equals(this.additionalProperties, eventAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationKey, this.dateHappened, this.deviceName, this.duration, this.eventObject, this.evt, this.hostname, this.monitor, this.monitorGroups, this.monitorId, this.priority, this.relatedEventId, this.service, this.sourceTypeName, this.sourcecategory, this.status, this.tags, this.timestamp, this.title, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventAttributes {\n");
        sb.append("    aggregationKey: ").append(this.toIndentedString(this.aggregationKey)).append("\n");
        sb.append("    dateHappened: ").append(this.toIndentedString(this.dateHappened)).append("\n");
        sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    eventObject: ").append(this.toIndentedString(this.eventObject)).append("\n");
        sb.append("    evt: ").append(this.toIndentedString(this.evt)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    monitor: ").append(this.toIndentedString(this.monitor)).append("\n");
        sb.append("    monitorGroups: ").append(this.toIndentedString(this.monitorGroups)).append("\n");
        sb.append("    monitorId: ").append(this.toIndentedString(this.monitorId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    relatedEventId: ").append(this.toIndentedString(this.relatedEventId)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    sourceTypeName: ").append(this.toIndentedString(this.sourceTypeName)).append("\n");
        sb.append("    sourcecategory: ").append(this.toIndentedString(this.sourcecategory)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

