/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FastlyService;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_key", "name", "services"})
public class FastlyAccountCreateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEY = "api_key";
    private String apiKey;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<FastlyService> services = null;
    private Map<String, Object> additionalProperties;

    public FastlyAccountCreateRequestAttributes() {
    }

    @JsonCreator
    public FastlyAccountCreateRequestAttributes(@JsonProperty(required=true, value="api_key") String apiKey, @JsonProperty(required=true, value="name") String name) {
        this.apiKey = apiKey;
        this.name = name;
    }

    public FastlyAccountCreateRequestAttributes apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="api_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public FastlyAccountCreateRequestAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FastlyAccountCreateRequestAttributes services(List<FastlyService> services) {
        this.services = services;
        for (FastlyService item : services) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FastlyAccountCreateRequestAttributes addServicesItem(FastlyService servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<FastlyService>();
        }
        this.services.add(servicesItem);
        this.unparsed |= servicesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FastlyService> getServices() {
        return this.services;
    }

    public void setServices(List<FastlyService> services) {
        this.services = services;
    }

    @JsonAnySetter
    public FastlyAccountCreateRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastlyAccountCreateRequestAttributes fastlyAccountCreateRequestAttributes = (FastlyAccountCreateRequestAttributes)o;
        return Objects.equals(this.apiKey, fastlyAccountCreateRequestAttributes.apiKey) && Objects.equals(this.name, fastlyAccountCreateRequestAttributes.name) && Objects.equals(this.services, fastlyAccountCreateRequestAttributes.services) && Objects.equals(this.additionalProperties, fastlyAccountCreateRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.name, this.services, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FastlyAccountCreateRequestAttributes {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

