/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.HourlyUsageMeasurement;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"measurements", "org_name", "product_family", "public_id", "region", "timestamp"})
public class HourlyUsageAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_MEASUREMENTS = "measurements";
    private List<HourlyUsageMeasurement> measurements = null;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PRODUCT_FAMILY = "product_family";
    private String productFamily;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;
    private Map<String, Object> additionalProperties;

    public HourlyUsageAttributes measurements(List<HourlyUsageMeasurement> measurements) {
        this.measurements = measurements;
        for (HourlyUsageMeasurement item : measurements) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HourlyUsageAttributes addMeasurementsItem(HourlyUsageMeasurement measurementsItem) {
        if (this.measurements == null) {
            this.measurements = new ArrayList<HourlyUsageMeasurement>();
        }
        this.measurements.add(measurementsItem);
        this.unparsed |= measurementsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="measurements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HourlyUsageMeasurement> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<HourlyUsageMeasurement> measurements) {
        this.measurements = measurements;
    }

    public HourlyUsageAttributes orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public HourlyUsageAttributes productFamily(String productFamily) {
        this.productFamily = productFamily;
        return this;
    }

    @Nullable
    @JsonProperty(value="product_family")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(String productFamily) {
        this.productFamily = productFamily;
    }

    public HourlyUsageAttributes publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public HourlyUsageAttributes region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public HourlyUsageAttributes timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @JsonAnySetter
    public HourlyUsageAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HourlyUsageAttributes hourlyUsageAttributes = (HourlyUsageAttributes)o;
        return Objects.equals(this.measurements, hourlyUsageAttributes.measurements) && Objects.equals(this.orgName, hourlyUsageAttributes.orgName) && Objects.equals(this.productFamily, hourlyUsageAttributes.productFamily) && Objects.equals(this.publicId, hourlyUsageAttributes.publicId) && Objects.equals(this.region, hourlyUsageAttributes.region) && Objects.equals(this.timestamp, hourlyUsageAttributes.timestamp) && Objects.equals(this.additionalProperties, hourlyUsageAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.measurements, this.orgName, this.productFamily, this.publicId, this.region, this.timestamp, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HourlyUsageAttributes {\n");
        sb.append("    measurements: ").append(this.toIndentedString(this.measurements)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    productFamily: ").append(this.toIndentedString(this.productFamily)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

