/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DowntimeMeta;
import com.datadog.api.client.v2.model.DowntimeResponseData;
import com.datadog.api.client.v2.model.DowntimeResponseIncludedItem;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "included", "meta"})
public class ListDowntimesResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<DowntimeResponseData> data = null;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<DowntimeResponseIncludedItem> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private DowntimeMeta meta;
    private Map<String, Object> additionalProperties;

    public ListDowntimesResponse data(List<DowntimeResponseData> data) {
        this.data = data;
        for (DowntimeResponseData item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ListDowntimesResponse addDataItem(DowntimeResponseData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<DowntimeResponseData>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DowntimeResponseData> getData() {
        return this.data;
    }

    public void setData(List<DowntimeResponseData> data) {
        this.data = data;
    }

    public ListDowntimesResponse included(List<DowntimeResponseIncludedItem> included) {
        this.included = included;
        for (DowntimeResponseIncludedItem item : included) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ListDowntimesResponse addIncludedItem(DowntimeResponseIncludedItem includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<DowntimeResponseIncludedItem>();
        }
        this.included.add(includedItem);
        this.unparsed |= includedItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DowntimeResponseIncludedItem> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<DowntimeResponseIncludedItem> included) {
        this.included = included;
    }

    public ListDowntimesResponse meta(DowntimeMeta meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowntimeMeta getMeta() {
        return this.meta;
    }

    public void setMeta(DowntimeMeta meta) {
        this.meta = meta;
    }

    @JsonAnySetter
    public ListDowntimesResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListDowntimesResponse listDowntimesResponse = (ListDowntimesResponse)o;
        return Objects.equals(this.data, listDowntimesResponse.data) && Objects.equals(this.included, listDowntimesResponse.included) && Objects.equals(this.meta, listDowntimesResponse.meta) && Objects.equals(this.additionalProperties, listDowntimesResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListDowntimesResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

