/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MetricIntakeType;
import com.datadog.api.client.v2.model.MetricMetadata;
import com.datadog.api.client.v2.model.MetricPoint;
import com.datadog.api.client.v2.model.MetricResource;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"interval", "metadata", "metric", "points", "resources", "source_type_name", "tags", "type", "unit"})
public class MetricSeries {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Long interval;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private MetricMetadata metadata;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_POINTS = "points";
    private List<MetricPoint> points = new ArrayList<MetricPoint>();
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private List<MetricResource> resources = null;
    public static final String JSON_PROPERTY_SOURCE_TYPE_NAME = "source_type_name";
    private String sourceTypeName;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MetricIntakeType type;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private String unit;
    private Map<String, Object> additionalProperties;

    public MetricSeries() {
    }

    @JsonCreator
    public MetricSeries(@JsonProperty(required=true, value="metric") String metric, @JsonProperty(required=true, value="points") List<MetricPoint> points) {
        this.metric = metric;
        this.points = points;
    }

    public MetricSeries interval(Long interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public MetricSeries metadata(MetricMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetricMetadata metadata) {
        this.metadata = metadata;
    }

    public MetricSeries metric(String metric) {
        this.metric = metric;
        return this;
    }

    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public MetricSeries points(List<MetricPoint> points) {
        this.points = points;
        for (MetricPoint item : points) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MetricSeries addPointsItem(MetricPoint pointsItem) {
        this.points.add(pointsItem);
        this.unparsed |= pointsItem.unparsed;
        return this;
    }

    @JsonProperty(value="points")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<MetricPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<MetricPoint> points) {
        this.points = points;
    }

    public MetricSeries resources(List<MetricResource> resources) {
        this.resources = resources;
        for (MetricResource item : resources) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MetricSeries addResourcesItem(MetricResource resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<MetricResource>();
        }
        this.resources.add(resourcesItem);
        this.unparsed |= resourcesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MetricResource> getResources() {
        return this.resources;
    }

    public void setResources(List<MetricResource> resources) {
        this.resources = resources;
    }

    public MetricSeries sourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_type_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public MetricSeries tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricSeries addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MetricSeries type(MetricIntakeType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricIntakeType getType() {
        return this.type;
    }

    public void setType(MetricIntakeType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public MetricSeries unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nullable
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @JsonAnySetter
    public MetricSeries putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricSeries metricSeries = (MetricSeries)o;
        return Objects.equals(this.interval, metricSeries.interval) && Objects.equals(this.metadata, metricSeries.metadata) && Objects.equals(this.metric, metricSeries.metric) && Objects.equals(this.points, metricSeries.points) && Objects.equals(this.resources, metricSeries.resources) && Objects.equals(this.sourceTypeName, metricSeries.sourceTypeName) && Objects.equals(this.tags, metricSeries.tags) && Objects.equals(this.type, metricSeries.type) && Objects.equals(this.unit, metricSeries.unit) && Objects.equals(this.additionalProperties, metricSeries.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.metadata, this.metric, this.points, this.resources, this.sourceTypeName, this.tags, this.type, this.unit, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricSeries {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    sourceTypeName: ").append(this.toIndentedString(this.sourceTypeName)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

