/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FindingMuteReason;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "expiration_date", "muted", "reason"})
public class MuteFindingResponseProperties {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expiration_date";
    private Long expirationDate;
    public static final String JSON_PROPERTY_MUTED = "muted";
    private Boolean muted;
    public static final String JSON_PROPERTY_REASON = "reason";
    private FindingMuteReason reason;

    public MuteFindingResponseProperties description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MuteFindingResponseProperties expirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="expiration_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public MuteFindingResponseProperties muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @Nullable
    @JsonProperty(value="muted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public MuteFindingResponseProperties reason(FindingMuteReason reason) {
        this.reason = reason;
        this.unparsed |= !reason.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FindingMuteReason getReason() {
        return this.reason;
    }

    public void setReason(FindingMuteReason reason) {
        if (!reason.isValid()) {
            this.unparsed = true;
        }
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MuteFindingResponseProperties muteFindingResponseProperties = (MuteFindingResponseProperties)o;
        return Objects.equals(this.description, muteFindingResponseProperties.description) && Objects.equals(this.expirationDate, muteFindingResponseProperties.expirationDate) && Objects.equals(this.muted, muteFindingResponseProperties.muted) && Objects.equals(this.reason, muteFindingResponseProperties.reason);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.expirationDate, this.muted, this.reason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MuteFindingResponseProperties {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

