/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RUMAggregateSort;
import com.datadog.api.client.v2.model.RUMGroupByHistogram;
import com.datadog.api.client.v2.model.RUMGroupByMissing;
import com.datadog.api.client.v2.model.RUMGroupByTotal;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"facet", "histogram", "limit", "missing", "sort", "total"})
public class RUMGroupBy {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FACET = "facet";
    private String facet;
    public static final String JSON_PROPERTY_HISTOGRAM = "histogram";
    private RUMGroupByHistogram histogram;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Long limit = 10L;
    public static final String JSON_PROPERTY_MISSING = "missing";
    private RUMGroupByMissing missing;
    public static final String JSON_PROPERTY_SORT = "sort";
    private RUMAggregateSort sort;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private RUMGroupByTotal total = new RUMGroupByTotal(false);
    private Map<String, Object> additionalProperties;

    public RUMGroupBy() {
    }

    @JsonCreator
    public RUMGroupBy(@JsonProperty(required=true, value="facet") String facet) {
        this.facet = facet;
    }

    public RUMGroupBy facet(String facet) {
        this.facet = facet;
        return this;
    }

    @JsonProperty(value="facet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public RUMGroupBy histogram(RUMGroupByHistogram histogram) {
        this.histogram = histogram;
        this.unparsed |= histogram.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="histogram")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMGroupByHistogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(RUMGroupByHistogram histogram) {
        this.histogram = histogram;
    }

    public RUMGroupBy limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public RUMGroupBy missing(RUMGroupByMissing missing) {
        this.missing = missing;
        this.unparsed |= missing.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="missing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMGroupByMissing getMissing() {
        return this.missing;
    }

    public void setMissing(RUMGroupByMissing missing) {
        this.missing = missing;
    }

    public RUMGroupBy sort(RUMAggregateSort sort) {
        this.sort = sort;
        this.unparsed |= sort.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMAggregateSort getSort() {
        return this.sort;
    }

    public void setSort(RUMAggregateSort sort) {
        this.sort = sort;
    }

    public RUMGroupBy total(RUMGroupByTotal total) {
        this.total = total;
        this.unparsed |= total.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMGroupByTotal getTotal() {
        return this.total;
    }

    public void setTotal(RUMGroupByTotal total) {
        this.total = total;
    }

    @JsonAnySetter
    public RUMGroupBy putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMGroupBy rumGroupBy = (RUMGroupBy)o;
        return Objects.equals(this.facet, rumGroupBy.facet) && Objects.equals(this.histogram, rumGroupBy.histogram) && Objects.equals(this.limit, rumGroupBy.limit) && Objects.equals(this.missing, rumGroupBy.missing) && Objects.equals(this.sort, rumGroupBy.sort) && Objects.equals(this.total, rumGroupBy.total) && Objects.equals(this.additionalProperties, rumGroupBy.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.facet, this.histogram, this.limit, this.missing, this.sort, this.total, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMGroupBy {\n");
        sb.append("    facet: ").append(this.toIndentedString(this.facet)).append("\n");
        sb.append("    histogram: ").append(this.toIndentedString(this.histogram)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    missing: ").append(this.toIndentedString(this.missing)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

