/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityFilterExclusionFilter;
import com.datadog.api.client.v2.model.SecurityFilterFilteredDataType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"exclusion_filters", "filtered_data_type", "is_enabled", "name", "query", "version"})
public class SecurityFilterUpdateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<SecurityFilterExclusionFilter> exclusionFilters = null;
    public static final String JSON_PROPERTY_FILTERED_DATA_TYPE = "filtered_data_type";
    private SecurityFilterFilteredDataType filteredDataType;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    private Map<String, Object> additionalProperties;

    public SecurityFilterUpdateAttributes exclusionFilters(List<SecurityFilterExclusionFilter> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (SecurityFilterExclusionFilter item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityFilterUpdateAttributes addExclusionFiltersItem(SecurityFilterExclusionFilter exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<SecurityFilterExclusionFilter>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityFilterExclusionFilter> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<SecurityFilterExclusionFilter> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public SecurityFilterUpdateAttributes filteredDataType(SecurityFilterFilteredDataType filteredDataType) {
        this.filteredDataType = filteredDataType;
        this.unparsed |= !filteredDataType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="filtered_data_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityFilterFilteredDataType getFilteredDataType() {
        return this.filteredDataType;
    }

    public void setFilteredDataType(SecurityFilterFilteredDataType filteredDataType) {
        if (!filteredDataType.isValid()) {
            this.unparsed = true;
        }
        this.filteredDataType = filteredDataType;
    }

    public SecurityFilterUpdateAttributes isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityFilterUpdateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityFilterUpdateAttributes query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SecurityFilterUpdateAttributes version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonAnySetter
    public SecurityFilterUpdateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityFilterUpdateAttributes securityFilterUpdateAttributes = (SecurityFilterUpdateAttributes)o;
        return Objects.equals(this.exclusionFilters, securityFilterUpdateAttributes.exclusionFilters) && Objects.equals(this.filteredDataType, securityFilterUpdateAttributes.filteredDataType) && Objects.equals(this.isEnabled, securityFilterUpdateAttributes.isEnabled) && Objects.equals(this.name, securityFilterUpdateAttributes.name) && Objects.equals(this.query, securityFilterUpdateAttributes.query) && Objects.equals(this.version, securityFilterUpdateAttributes.version) && Objects.equals(this.additionalProperties, securityFilterUpdateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.exclusionFilters, this.filteredDataType, this.isEnabled, this.name, this.query, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityFilterUpdateAttributes {\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filteredDataType: ").append(this.toIndentedString(this.filteredDataType)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

