/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringRuleQueryAggregation;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation", "correlatedByFields", "correlatedQueryIndex", "metrics", "name", "ruleId"})
public class SecurityMonitoringSignalRuleQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private SecurityMonitoringRuleQueryAggregation aggregation;
    public static final String JSON_PROPERTY_CORRELATED_BY_FIELDS = "correlatedByFields";
    private List<String> correlatedByFields = null;
    public static final String JSON_PROPERTY_CORRELATED_QUERY_INDEX = "correlatedQueryIndex";
    private Integer correlatedQueryIndex;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private List<String> metrics = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_RULE_ID = "ruleId";
    private String ruleId;
    private Map<String, Object> additionalProperties;

    public SecurityMonitoringSignalRuleQuery() {
    }

    @JsonCreator
    public SecurityMonitoringSignalRuleQuery(@JsonProperty(required=true, value="ruleId") String ruleId) {
        this.ruleId = ruleId;
    }

    public SecurityMonitoringSignalRuleQuery aggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleQueryAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public SecurityMonitoringSignalRuleQuery correlatedByFields(List<String> correlatedByFields) {
        this.correlatedByFields = correlatedByFields;
        return this;
    }

    public SecurityMonitoringSignalRuleQuery addCorrelatedByFieldsItem(String correlatedByFieldsItem) {
        if (this.correlatedByFields == null) {
            this.correlatedByFields = new ArrayList<String>();
        }
        this.correlatedByFields.add(correlatedByFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="correlatedByFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCorrelatedByFields() {
        return this.correlatedByFields;
    }

    public void setCorrelatedByFields(List<String> correlatedByFields) {
        this.correlatedByFields = correlatedByFields;
    }

    public SecurityMonitoringSignalRuleQuery correlatedQueryIndex(Integer correlatedQueryIndex) {
        this.correlatedQueryIndex = correlatedQueryIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="correlatedQueryIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCorrelatedQueryIndex() {
        return this.correlatedQueryIndex;
    }

    public void setCorrelatedQueryIndex(Integer correlatedQueryIndex) {
        this.correlatedQueryIndex = correlatedQueryIndex;
    }

    public SecurityMonitoringSignalRuleQuery metrics(List<String> metrics) {
        this.metrics = metrics;
        return this;
    }

    public SecurityMonitoringSignalRuleQuery addMetricsItem(String metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<String>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public SecurityMonitoringSignalRuleQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringSignalRuleQuery ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @JsonProperty(value="ruleId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @JsonAnySetter
    public SecurityMonitoringSignalRuleQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringSignalRuleQuery securityMonitoringSignalRuleQuery = (SecurityMonitoringSignalRuleQuery)o;
        return Objects.equals(this.aggregation, securityMonitoringSignalRuleQuery.aggregation) && Objects.equals(this.correlatedByFields, securityMonitoringSignalRuleQuery.correlatedByFields) && Objects.equals(this.correlatedQueryIndex, securityMonitoringSignalRuleQuery.correlatedQueryIndex) && Objects.equals(this.metrics, securityMonitoringSignalRuleQuery.metrics) && Objects.equals(this.name, securityMonitoringSignalRuleQuery.name) && Objects.equals(this.ruleId, securityMonitoringSignalRuleQuery.ruleId) && Objects.equals(this.additionalProperties, securityMonitoringSignalRuleQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.correlatedByFields, this.correlatedQueryIndex, this.metrics, this.name, this.ruleId, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringSignalRuleQuery {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    correlatedByFields: ").append(this.toIndentedString(this.correlatedByFields)).append("\n");
        sb.append("    correlatedQueryIndex: ").append(this.toIndentedString(this.correlatedQueryIndex)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

