/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Span;
import com.datadog.api.client.v2.model.SpansListResponseLinks;
import com.datadog.api.client.v2.model.SpansListResponseMetadata;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "links", "meta"})
public class SpansListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Span> data = null;
    public static final String JSON_PROPERTY_LINKS = "links";
    private SpansListResponseLinks links;
    public static final String JSON_PROPERTY_META = "meta";
    private SpansListResponseMetadata meta;
    private Map<String, Object> additionalProperties;

    public SpansListResponse data(List<Span> data) {
        this.data = data;
        for (Span item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SpansListResponse addDataItem(Span dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Span>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Span> getData() {
        return this.data;
    }

    public void setData(List<Span> data) {
        this.data = data;
    }

    public SpansListResponse links(SpansListResponseLinks links) {
        this.links = links;
        this.unparsed |= links.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SpansListResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(SpansListResponseLinks links) {
        this.links = links;
    }

    public SpansListResponse meta(SpansListResponseMetadata meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SpansListResponseMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(SpansListResponseMetadata meta) {
        this.meta = meta;
    }

    @JsonAnySetter
    public SpansListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpansListResponse spansListResponse = (SpansListResponse)o;
        return Objects.equals(this.data, spansListResponse.data) && Objects.equals(this.links, spansListResponse.links) && Objects.equals(this.meta, spansListResponse.meta) && Objects.equals(this.additionalProperties, spansListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpansListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

