/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.oauth;

import com.datadoghq.com.github.scribejava.core.httpclient.HttpClient;
import com.datadoghq.com.github.scribejava.core.httpclient.HttpClientConfig;
import com.datadoghq.com.github.scribejava.core.httpclient.HttpClientProvider;
import com.datadoghq.com.github.scribejava.core.httpclient.jdk.JDKHttpClient;
import com.datadoghq.com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.datadoghq.com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.datadoghq.com.github.scribejava.core.model.OAuthRequest;
import com.datadoghq.com.github.scribejava.core.model.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class OAuthService
implements Closeable {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final String userAgent;
    private final HttpClient httpClient;
    private final OutputStream debugStream;

    public OAuthService(String apiKey, String apiSecret, String callback, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.callback = callback;
        this.debugStream = debugStream;
        this.userAgent = userAgent;
        this.httpClient = httpClientConfig == null && httpClient == null ? new JDKHttpClient(JDKHttpClientConfig.defaultConfig()) : (httpClient == null ? OAuthService.getClient(httpClientConfig) : httpClient);
    }

    private static HttpClient getClient(HttpClientConfig config) {
        for (HttpClientProvider provider : ServiceLoader.load(HttpClientProvider.class)) {
            HttpClient client = provider.createClient(config);
            if (client == null) continue;
            return client;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public abstract String getVersion();

    public Future<Response> executeAsync(OAuthRequest request) {
        return this.execute(request, null);
    }

    public Future<Response> execute(OAuthRequest request, OAuthAsyncRequestCallback<Response> callback) {
        return this.execute(request, callback, null);
    }

    public <R> Future<R> execute(OAuthRequest request, OAuthAsyncRequestCallback<R> callback, OAuthRequest.ResponseConverter<R> converter) {
        File filePayload = request.getFilePayload();
        if (filePayload != null) {
            return this.httpClient.executeAsync(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), filePayload, callback, converter);
        }
        if (request.getStringPayload() != null) {
            return this.httpClient.executeAsync(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getStringPayload(), callback, converter);
        }
        return this.httpClient.executeAsync(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getByteArrayPayload(), callback, converter);
    }

    public Response execute(OAuthRequest request) throws InterruptedException, ExecutionException, IOException {
        File filePayload = request.getFilePayload();
        if (filePayload != null) {
            return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), filePayload);
        }
        if (request.getStringPayload() != null) {
            return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getStringPayload());
        }
        if (request.getMultipartPayload() != null) {
            return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getMultipartPayload());
        }
        return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getByteArrayPayload());
    }

    public void log(String message) {
        if (this.debugStream != null) {
            this.log(message, null);
        }
    }

    public void log(String messagePattern, Object ... params) {
        String message = String.format(messagePattern, params) + '\n';
        try {
            this.debugStream.write(message.getBytes("UTF8"));
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("there were problems while writting to the debug stream", e);
        }
    }

    protected boolean isDebug() {
        return this.debugStream != null;
    }
}

