/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.services;

import com.datadoghq.com.github.scribejava.core.exceptions.OAuthSignatureException;
import com.datadoghq.com.github.scribejava.core.services.SignatureService;
import com.datadoghq.com.github.scribejava.core.utils.OAuthEncoder;
import com.datadoghq.com.github.scribejava.core.utils.Preconditions;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "PLAINTEXT";

    @Override
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkNotNull(apiSecret, "Api secret can't be null");
            return OAuthEncoder.encode(apiSecret) + '&' + OAuthEncoder.encode(tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

