/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.glassfish.jersey.apache.connector;

import com.datadoghq.org.glassfish.jersey.client.ClientRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public interface ApacheConnectionClosingStrategy {
    public void close(ClientRequest var1, HttpUriRequest var2, CloseableHttpResponse var3, InputStream var4) throws IOException;

    public static class ImmediateClosingStrategy
    implements ApacheConnectionClosingStrategy {
        static final ImmediateClosingStrategy INSTANCE = new ImmediateClosingStrategy();

        @Override
        public void close(ClientRequest clientRequest, HttpUriRequest request, CloseableHttpResponse response, InputStream stream) throws IOException {
            response.close();
            stream.close();
        }
    }

    public static class GracefulClosingStrategy
    implements ApacheConnectionClosingStrategy {
        private static final String UNIX_PROTOCOL = "unix";
        static final GracefulClosingStrategy INSTANCE = new GracefulClosingStrategy();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(ClientRequest clientRequest, HttpUriRequest request, CloseableHttpResponse response, InputStream stream) throws IOException {
            if (response.getEntity() != null && response.getEntity().isChunked() && !request.getURI().getScheme().equals(UNIX_PROTOCOL)) {
                request.abort();
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                response.close();
            }
        }
    }
}

