/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.glassfish.jersey.jackson.internal;

import com.datadoghq.com.fasterxml.jackson.databind.Module;
import com.datadoghq.com.fasterxml.jackson.databind.ObjectMapper;
import com.datadoghq.jakarta.ws.rs.core.Configuration;
import com.datadoghq.jakarta.ws.rs.core.Context;
import com.datadoghq.org.glassfish.jersey.CommonProperties;
import com.datadoghq.org.glassfish.jersey.jackson.internal.JacksonMapperConfigurator;
import com.datadoghq.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations;
import com.datadoghq.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.datadoghq.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonMapperConfigurator;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;

@Singleton
public class DefaultJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider {
    @Context
    private Configuration commonConfig;
    private static final String[] EXCLUDE_MODULE_NAMES = new String[]{"JaxbAnnotationModule", "JakartaXmlBindAnnotationModule"};

    public DefaultJacksonJaxbJsonProvider() {
        super(new JacksonMapperConfigurator(null, DEFAULT_ANNOTATIONS));
    }

    public DefaultJacksonJaxbJsonProvider(Annotations ... annotationsToUse) {
        super(new JacksonMapperConfigurator(null, annotationsToUse));
    }

    @PostConstruct
    private void findAndRegisterModules() {
        ObjectMapper defaultMapper = ((JsonMapperConfigurator)this._mapperConfig).getDefaultMapper();
        ObjectMapper mapper = ((JsonMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        List<Module> modules = this.filterModules();
        defaultMapper.registerModules(modules);
        if (mapper != null) {
            mapper.registerModules(modules);
        }
    }

    private List<Module> filterModules() {
        String disabledModules = CommonProperties.getValue(this.commonConfig.getProperties(), this.commonConfig.getRuntimeType(), "jersey.config.json.jackson.disabled.modules", String.class);
        String enabledModules = CommonProperties.getValue(this.commonConfig.getProperties(), this.commonConfig.getRuntimeType(), "jersey.config.json.jackson.enabled.modules", String.class);
        List<Module> modules = ObjectMapper.findModules();
        for (String exludeModuleName : EXCLUDE_MODULE_NAMES) {
            modules.removeIf(mod -> mod.getModuleName().contains(exludeModuleName));
        }
        if (enabledModules != null && !enabledModules.isEmpty()) {
            List<String> enabledModulesList = Arrays.asList(enabledModules.split(","));
            modules.removeIf(mod -> !enabledModulesList.contains(mod.getModuleName()));
        } else if (disabledModules != null && !disabledModules.isEmpty()) {
            List<String> disabledModulesList = Arrays.asList(disabledModules.split(","));
            modules.removeIf(mod -> disabledModulesList.contains(mod.getModuleName()));
        }
        return modules;
    }
}

