/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.glassfish.jersey.message.filtering;

import com.datadoghq.jakarta.ws.rs.ConstrainedTo;
import com.datadoghq.jakarta.ws.rs.RuntimeType;
import com.datadoghq.jakarta.ws.rs.core.Configuration;
import com.datadoghq.jakarta.ws.rs.core.Context;
import com.datadoghq.jakarta.ws.rs.core.SecurityContext;
import com.datadoghq.org.glassfish.jersey.internal.inject.InjectionManager;
import com.datadoghq.org.glassfish.jersey.message.filtering.SecurityHelper;
import com.datadoghq.org.glassfish.jersey.message.filtering.ServerScopeProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, InjectionManager injectionManager) {
        super(config, injectionManager);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = new HashSet<String>();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

