/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 */

package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** RUM application creation request attributes. */
@JsonPropertyOrder({RUMApplicationCreateRequest.JSON_PROPERTY_DATA})
@jakarta.annotation.Generated(
    value = "https://github.com/DataDog/datadog-api-client-java/blob/master/.generator")
public class RUMApplicationCreateRequest {
  @JsonIgnore public boolean unparsed = false;
  public static final String JSON_PROPERTY_DATA = "data";
  private RUMApplicationCreate data;

  public RUMApplicationCreateRequest() {}

  @JsonCreator
  public RUMApplicationCreateRequest(
      @JsonProperty(required = true, value = JSON_PROPERTY_DATA) RUMApplicationCreate data) {
    this.data = data;
    this.unparsed |= data.unparsed;
  }

  public RUMApplicationCreateRequest data(RUMApplicationCreate data) {
    this.data = data;
    this.unparsed |= data.unparsed;
    return this;
  }

  /**
   * RUM application creation.
   *
   * @return data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public RUMApplicationCreate getData() {
    return data;
  }

  public void setData(RUMApplicationCreate data) {
    this.data = data;
  }

  /** Return true if this RUMApplicationCreateRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RUMApplicationCreateRequest rumApplicationCreateRequest = (RUMApplicationCreateRequest) o;
    return Objects.equals(this.data, rumApplicationCreateRequest.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RUMApplicationCreateRequest {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
