/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.GraphSnapshot;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class SnapshotsApi {
    private ApiClient apiClient;

    public SnapshotsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SnapshotsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GraphSnapshot getGraphSnapshot(Long start, Long end) throws ApiException {
        return this.getGraphSnapshotWithHttpInfo(start, end, new GetGraphSnapshotOptionalParameters()).getData();
    }

    public CompletableFuture<GraphSnapshot> getGraphSnapshotAsync(Long start, Long end) {
        return this.getGraphSnapshotWithHttpInfoAsync(start, end, new GetGraphSnapshotOptionalParameters()).thenApply(response -> (GraphSnapshot)response.getData());
    }

    public GraphSnapshot getGraphSnapshot(Long start, Long end, GetGraphSnapshotOptionalParameters parameters) throws ApiException {
        return this.getGraphSnapshotWithHttpInfo(start, end, parameters).getData();
    }

    public CompletableFuture<GraphSnapshot> getGraphSnapshotAsync(Long start, Long end, GetGraphSnapshotOptionalParameters parameters) {
        return this.getGraphSnapshotWithHttpInfoAsync(start, end, parameters).thenApply(response -> (GraphSnapshot)response.getData());
    }

    public ApiResponse<GraphSnapshot> getGraphSnapshotWithHttpInfo(Long start, Long end, GetGraphSnapshotOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (start == null) {
            throw new ApiException(400, "Missing the required parameter 'start' when calling getGraphSnapshot");
        }
        if (end == null) {
            throw new ApiException(400, "Missing the required parameter 'end' when calling getGraphSnapshot");
        }
        String metricQuery = parameters.metricQuery;
        String eventQuery = parameters.eventQuery;
        String graphDef = parameters.graphDef;
        String title = parameters.title;
        Long height = parameters.height;
        Long width = parameters.width;
        String localVarPath = "/api/v1/graph/snapshot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metric_query", metricQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "event_query", eventQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "graph_def", graphDef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "title", title));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "width", width));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.SnapshotsApi.getGraphSnapshot", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GraphSnapshot>(){});
    }

    public CompletableFuture<ApiResponse<GraphSnapshot>> getGraphSnapshotWithHttpInfoAsync(Long start, Long end, GetGraphSnapshotOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (start == null) {
            CompletableFuture<ApiResponse<GraphSnapshot>> result = new CompletableFuture<ApiResponse<GraphSnapshot>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'start' when calling getGraphSnapshot"));
            return result;
        }
        if (end == null) {
            CompletableFuture<ApiResponse<GraphSnapshot>> result = new CompletableFuture<ApiResponse<GraphSnapshot>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'end' when calling getGraphSnapshot"));
            return result;
        }
        String metricQuery = parameters.metricQuery;
        String eventQuery = parameters.eventQuery;
        String graphDef = parameters.graphDef;
        String title = parameters.title;
        Long height = parameters.height;
        Long width = parameters.width;
        String localVarPath = "/api/v1/graph/snapshot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metric_query", metricQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "event_query", eventQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "graph_def", graphDef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "title", title));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "width", width));
        try {
            builder = this.apiClient.createBuilder("v1.SnapshotsApi.getGraphSnapshot", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GraphSnapshot>> result = new CompletableFuture<ApiResponse<GraphSnapshot>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GraphSnapshot>(){});
    }

    public static class GetGraphSnapshotOptionalParameters {
        private String metricQuery;
        private String eventQuery;
        private String graphDef;
        private String title;
        private Long height;
        private Long width;

        public GetGraphSnapshotOptionalParameters metricQuery(String metricQuery) {
            this.metricQuery = metricQuery;
            return this;
        }

        public GetGraphSnapshotOptionalParameters eventQuery(String eventQuery) {
            this.eventQuery = eventQuery;
            return this;
        }

        public GetGraphSnapshotOptionalParameters graphDef(String graphDef) {
            this.graphDef = graphDef;
            return this;
        }

        public GetGraphSnapshotOptionalParameters title(String title) {
            this.title = title;
            return this;
        }

        public GetGraphSnapshotOptionalParameters height(Long height) {
            this.height = height;
            return this;
        }

        public GetGraphSnapshotOptionalParameters width(Long width) {
            this.width = width;
            return this;
        }
    }
}

