/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.AWSEventBridgeSource;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountId", "eventHubs", "tags"})
public class AWSEventBridgeAccountConfiguration {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private String accountId;
    public static final String JSON_PROPERTY_EVENT_HUBS = "eventHubs";
    private List<AWSEventBridgeSource> eventHubs = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public AWSEventBridgeAccountConfiguration accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSEventBridgeAccountConfiguration eventHubs(List<AWSEventBridgeSource> eventHubs) {
        this.eventHubs = eventHubs;
        for (AWSEventBridgeSource item : eventHubs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AWSEventBridgeAccountConfiguration addEventHubsItem(AWSEventBridgeSource eventHubsItem) {
        if (this.eventHubs == null) {
            this.eventHubs = new ArrayList<AWSEventBridgeSource>();
        }
        this.eventHubs.add(eventHubsItem);
        this.unparsed |= eventHubsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="eventHubs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AWSEventBridgeSource> getEventHubs() {
        return this.eventHubs;
    }

    public void setEventHubs(List<AWSEventBridgeSource> eventHubs) {
        this.eventHubs = eventHubs;
    }

    public AWSEventBridgeAccountConfiguration tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public AWSEventBridgeAccountConfiguration addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public AWSEventBridgeAccountConfiguration putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSEventBridgeAccountConfiguration awsEventBridgeAccountConfiguration = (AWSEventBridgeAccountConfiguration)o;
        return Objects.equals(this.accountId, awsEventBridgeAccountConfiguration.accountId) && Objects.equals(this.eventHubs, awsEventBridgeAccountConfiguration.eventHubs) && Objects.equals(this.tags, awsEventBridgeAccountConfiguration.tags) && Objects.equals(this.additionalProperties, awsEventBridgeAccountConfiguration.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.eventHubs, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSEventBridgeAccountConfiguration {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    eventHubs: ").append(this.toIndentedString(this.eventHubs)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

