/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.NotebookAuthor;
import com.datadog.api.client.v1.model.NotebookCellResponse;
import com.datadog.api.client.v1.model.NotebookGlobalTime;
import com.datadog.api.client.v1.model.NotebookMetadata;
import com.datadog.api.client.v1.model.NotebookStatus;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"author", "cells", "created", "metadata", "modified", "name", "status", "time"})
public class NotebookResponseDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private NotebookAuthor author;
    public static final String JSON_PROPERTY_CELLS = "cells";
    private List<NotebookCellResponse> cells = new ArrayList<NotebookCellResponse>();
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private NotebookMetadata metadata;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NotebookStatus status = NotebookStatus.PUBLISHED;
    public static final String JSON_PROPERTY_TIME = "time";
    private NotebookGlobalTime time;
    private Map<String, Object> additionalProperties;

    public NotebookResponseDataAttributes() {
    }

    @JsonCreator
    public NotebookResponseDataAttributes(@JsonProperty(required=true, value="cells") List<NotebookCellResponse> cells, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="time") NotebookGlobalTime time) {
        this.cells = cells;
        this.name = name;
        this.time = time;
        this.unparsed |= time.unparsed;
    }

    public NotebookResponseDataAttributes author(NotebookAuthor author) {
        this.author = author;
        this.unparsed |= author.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookAuthor getAuthor() {
        return this.author;
    }

    public void setAuthor(NotebookAuthor author) {
        this.author = author;
    }

    public NotebookResponseDataAttributes cells(List<NotebookCellResponse> cells) {
        this.cells = cells;
        for (NotebookCellResponse item : cells) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public NotebookResponseDataAttributes addCellsItem(NotebookCellResponse cellsItem) {
        this.cells.add(cellsItem);
        this.unparsed |= cellsItem.unparsed;
        return this;
    }

    @JsonProperty(value="cells")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<NotebookCellResponse> getCells() {
        return this.cells;
    }

    public void setCells(List<NotebookCellResponse> cells) {
        this.cells = cells;
    }

    @Nullable
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public NotebookResponseDataAttributes metadata(NotebookMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(NotebookMetadata metadata) {
        this.metadata = metadata;
    }

    @Nullable
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    public NotebookResponseDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotebookResponseDataAttributes status(NotebookStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookStatus getStatus() {
        return this.status;
    }

    public void setStatus(NotebookStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public NotebookResponseDataAttributes time(NotebookGlobalTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NotebookGlobalTime getTime() {
        return this.time;
    }

    public void setTime(NotebookGlobalTime time) {
        this.time = time;
    }

    @JsonAnySetter
    public NotebookResponseDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookResponseDataAttributes notebookResponseDataAttributes = (NotebookResponseDataAttributes)o;
        return Objects.equals(this.author, notebookResponseDataAttributes.author) && Objects.equals(this.cells, notebookResponseDataAttributes.cells) && Objects.equals(this.created, notebookResponseDataAttributes.created) && Objects.equals(this.metadata, notebookResponseDataAttributes.metadata) && Objects.equals(this.modified, notebookResponseDataAttributes.modified) && Objects.equals(this.name, notebookResponseDataAttributes.name) && Objects.equals(this.status, notebookResponseDataAttributes.status) && Objects.equals(this.time, notebookResponseDataAttributes.time) && Objects.equals(this.additionalProperties, notebookResponseDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.cells, this.created, this.metadata, this.modified, this.name, this.status, this.time, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookResponseDataAttributes {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    cells: ").append(this.toIndentedString(this.cells)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

