/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsAPITestConfig;
import com.datadog.api.client.v1.model.SyntheticsAPITestType;
import com.datadog.api.client.v1.model.SyntheticsTestDetailsSubType;
import com.datadog.api.client.v1.model.SyntheticsTestOptions;
import com.datadog.api.client.v1.model.SyntheticsTestPauseStatus;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"config", "locations", "message", "monitor_id", "name", "options", "public_id", "status", "subtype", "tags", "type"})
public class SyntheticsAPITest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private SyntheticsAPITestConfig config;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<String> locations = new ArrayList<String>();
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MONITOR_ID = "monitor_id";
    private Long monitorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SyntheticsTestOptions options;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SyntheticsTestPauseStatus status;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private SyntheticsTestDetailsSubType subtype;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsAPITestType type = SyntheticsAPITestType.API;
    private Map<String, Object> additionalProperties;

    public SyntheticsAPITest() {
    }

    @JsonCreator
    public SyntheticsAPITest(@JsonProperty(required=true, value="config") SyntheticsAPITestConfig config, @JsonProperty(required=true, value="locations") List<String> locations, @JsonProperty(required=true, value="message") String message, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="options") SyntheticsTestOptions options, @JsonProperty(required=true, value="type") SyntheticsAPITestType type) {
        this.config = config;
        this.unparsed |= config.unparsed;
        this.locations = locations;
        this.message = message;
        this.name = name;
        this.options = options;
        this.unparsed |= options.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SyntheticsAPITest config(SyntheticsAPITestConfig config) {
        this.config = config;
        this.unparsed |= config.unparsed;
        return this;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsAPITestConfig getConfig() {
        return this.config;
    }

    public void setConfig(SyntheticsAPITestConfig config) {
        this.config = config;
    }

    public SyntheticsAPITest locations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public SyntheticsAPITest addLocationsItem(String locationsItem) {
        this.locations.add(locationsItem);
        return this;
    }

    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public SyntheticsAPITest message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @JsonProperty(value="monitor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorId() {
        return this.monitorId;
    }

    public SyntheticsAPITest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsAPITest options(SyntheticsTestOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsTestOptions getOptions() {
        return this.options;
    }

    public void setOptions(SyntheticsTestOptions options) {
        this.options = options;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public SyntheticsAPITest status(SyntheticsTestPauseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestPauseStatus getStatus() {
        return this.status;
    }

    public void setStatus(SyntheticsTestPauseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public SyntheticsAPITest subtype(SyntheticsTestDetailsSubType subtype) {
        this.subtype = subtype;
        this.unparsed |= !subtype.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestDetailsSubType getSubtype() {
        return this.subtype;
    }

    public void setSubtype(SyntheticsTestDetailsSubType subtype) {
        if (!subtype.isValid()) {
            this.unparsed = true;
        }
        this.subtype = subtype;
    }

    public SyntheticsAPITest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsAPITest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SyntheticsAPITest type(SyntheticsAPITestType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsAPITestType getType() {
        return this.type;
    }

    public void setType(SyntheticsAPITestType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public SyntheticsAPITest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITest syntheticsApiTest = (SyntheticsAPITest)o;
        return Objects.equals(this.config, syntheticsApiTest.config) && Objects.equals(this.locations, syntheticsApiTest.locations) && Objects.equals(this.message, syntheticsApiTest.message) && Objects.equals(this.monitorId, syntheticsApiTest.monitorId) && Objects.equals(this.name, syntheticsApiTest.name) && Objects.equals(this.options, syntheticsApiTest.options) && Objects.equals(this.publicId, syntheticsApiTest.publicId) && Objects.equals(this.status, syntheticsApiTest.status) && Objects.equals(this.subtype, syntheticsApiTest.subtype) && Objects.equals(this.tags, syntheticsApiTest.tags) && Objects.equals(this.type, syntheticsApiTest.type) && Objects.equals(this.additionalProperties, syntheticsApiTest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.locations, this.message, this.monitorId, this.name, this.options, this.publicId, this.status, this.subtype, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITest {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    monitorId: ").append(this.toIndentedString(this.monitorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

