/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsAPITestStepSubtype;
import com.datadog.api.client.v1.model.SyntheticsAssertion;
import com.datadog.api.client.v1.model.SyntheticsParsingOptions;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsRetry;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"allowFailure", "assertions", "extractedValues", "isCritical", "name", "request", "retry", "subtype"})
public class SyntheticsAPITestStep {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALLOW_FAILURE = "allowFailure";
    private Boolean allowFailure;
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = new ArrayList<SyntheticsAssertion>();
    public static final String JSON_PROPERTY_EXTRACTED_VALUES = "extractedValues";
    private List<SyntheticsParsingOptions> extractedValues = null;
    public static final String JSON_PROPERTY_IS_CRITICAL = "isCritical";
    private Boolean isCritical;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_RETRY = "retry";
    private SyntheticsTestOptionsRetry retry;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private SyntheticsAPITestStepSubtype subtype;
    private Map<String, Object> additionalProperties;

    public SyntheticsAPITestStep() {
    }

    @JsonCreator
    public SyntheticsAPITestStep(@JsonProperty(required=true, value="assertions") List<SyntheticsAssertion> assertions, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="request") SyntheticsTestRequest request, @JsonProperty(required=true, value="subtype") SyntheticsAPITestStepSubtype subtype) {
        this.assertions = assertions;
        this.name = name;
        this.request = request;
        this.unparsed |= request.unparsed;
        this.subtype = subtype;
        this.unparsed |= !subtype.isValid();
    }

    public SyntheticsAPITestStep allowFailure(Boolean allowFailure) {
        this.allowFailure = allowFailure;
        return this;
    }

    @Nullable
    @JsonProperty(value="allowFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowFailure() {
        return this.allowFailure;
    }

    public void setAllowFailure(Boolean allowFailure) {
        this.allowFailure = allowFailure;
    }

    public SyntheticsAPITestStep assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        for (SyntheticsAssertion item : assertions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsAPITestStep addAssertionsItem(SyntheticsAssertion assertionsItem) {
        this.assertions.add(assertionsItem);
        this.unparsed |= assertionsItem.unparsed;
        return this;
    }

    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsAPITestStep extractedValues(List<SyntheticsParsingOptions> extractedValues) {
        this.extractedValues = extractedValues;
        for (SyntheticsParsingOptions item : extractedValues) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsAPITestStep addExtractedValuesItem(SyntheticsParsingOptions extractedValuesItem) {
        if (this.extractedValues == null) {
            this.extractedValues = new ArrayList<SyntheticsParsingOptions>();
        }
        this.extractedValues.add(extractedValuesItem);
        this.unparsed |= extractedValuesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="extractedValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsParsingOptions> getExtractedValues() {
        return this.extractedValues;
    }

    public void setExtractedValues(List<SyntheticsParsingOptions> extractedValues) {
        this.extractedValues = extractedValues;
    }

    public SyntheticsAPITestStep isCritical(Boolean isCritical) {
        this.isCritical = isCritical;
        return this;
    }

    @Nullable
    @JsonProperty(value="isCritical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCritical() {
        return this.isCritical;
    }

    public void setIsCritical(Boolean isCritical) {
        this.isCritical = isCritical;
    }

    public SyntheticsAPITestStep name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsAPITestStep request(SyntheticsTestRequest request) {
        this.request = request;
        this.unparsed |= request.unparsed;
        return this;
    }

    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsAPITestStep retry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
        this.unparsed |= retry.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="retry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptionsRetry getRetry() {
        return this.retry;
    }

    public void setRetry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
    }

    public SyntheticsAPITestStep subtype(SyntheticsAPITestStepSubtype subtype) {
        this.subtype = subtype;
        this.unparsed |= !subtype.isValid();
        return this;
    }

    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsAPITestStepSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(SyntheticsAPITestStepSubtype subtype) {
        if (!subtype.isValid()) {
            this.unparsed = true;
        }
        this.subtype = subtype;
    }

    @JsonAnySetter
    public SyntheticsAPITestStep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITestStep syntheticsApiTestStep = (SyntheticsAPITestStep)o;
        return Objects.equals(this.allowFailure, syntheticsApiTestStep.allowFailure) && Objects.equals(this.assertions, syntheticsApiTestStep.assertions) && Objects.equals(this.extractedValues, syntheticsApiTestStep.extractedValues) && Objects.equals(this.isCritical, syntheticsApiTestStep.isCritical) && Objects.equals(this.name, syntheticsApiTestStep.name) && Objects.equals(this.request, syntheticsApiTestStep.request) && Objects.equals(this.retry, syntheticsApiTestStep.retry) && Objects.equals(this.subtype, syntheticsApiTestStep.subtype) && Objects.equals(this.additionalProperties, syntheticsApiTestStep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.allowFailure, this.assertions, this.extractedValues, this.isCritical, this.name, this.request, this.retry, this.subtype, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITestStep {\n");
        sb.append("    allowFailure: ").append(this.toIndentedString(this.allowFailure)).append("\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    extractedValues: ").append(this.toIndentedString(this.extractedValues)).append("\n");
        sb.append("    isCritical: ").append(this.toIndentedString(this.isCritical)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    retry: ").append(this.toIndentedString(this.retry)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

