/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.GetTeamMembershipsSort;
import com.datadog.api.client.v2.model.ListTeamsInclude;
import com.datadog.api.client.v2.model.ListTeamsSort;
import com.datadog.api.client.v2.model.Team;
import com.datadog.api.client.v2.model.TeamCreateRequest;
import com.datadog.api.client.v2.model.TeamLinkCreateRequest;
import com.datadog.api.client.v2.model.TeamLinkResponse;
import com.datadog.api.client.v2.model.TeamLinksResponse;
import com.datadog.api.client.v2.model.TeamPermissionSettingResponse;
import com.datadog.api.client.v2.model.TeamPermissionSettingUpdateRequest;
import com.datadog.api.client.v2.model.TeamPermissionSettingsResponse;
import com.datadog.api.client.v2.model.TeamResponse;
import com.datadog.api.client.v2.model.TeamUpdateRequest;
import com.datadog.api.client.v2.model.TeamsField;
import com.datadog.api.client.v2.model.TeamsResponse;
import com.datadog.api.client.v2.model.UserTeam;
import com.datadog.api.client.v2.model.UserTeamRequest;
import com.datadog.api.client.v2.model.UserTeamResponse;
import com.datadog.api.client.v2.model.UserTeamUpdateRequest;
import com.datadog.api.client.v2.model.UserTeamsResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TeamsApi {
    private ApiClient apiClient;

    public TeamsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public TeamsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TeamResponse createTeam(TeamCreateRequest body) throws ApiException {
        return this.createTeamWithHttpInfo(body).getData();
    }

    public CompletableFuture<TeamResponse> createTeamAsync(TeamCreateRequest body) {
        return this.createTeamWithHttpInfoAsync(body).thenApply(response -> (TeamResponse)response.getData());
    }

    public ApiResponse<TeamResponse> createTeamWithHttpInfo(TeamCreateRequest body) throws ApiException {
        TeamCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTeam");
        }
        String localVarPath = "/api/v2/team";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.createTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamResponse>> createTeamWithHttpInfoAsync(TeamCreateRequest body) {
        Invocation.Builder builder;
        TeamCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTeam"));
            return result;
        }
        String localVarPath = "/api/v2/team";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.createTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamResponse>(){});
    }

    public TeamLinkResponse createTeamLink(String teamId, TeamLinkCreateRequest body) throws ApiException {
        return this.createTeamLinkWithHttpInfo(teamId, body).getData();
    }

    public CompletableFuture<TeamLinkResponse> createTeamLinkAsync(String teamId, TeamLinkCreateRequest body) {
        return this.createTeamLinkWithHttpInfoAsync(teamId, body).thenApply(response -> (TeamLinkResponse)response.getData());
    }

    public ApiResponse<TeamLinkResponse> createTeamLinkWithHttpInfo(String teamId, TeamLinkCreateRequest body) throws ApiException {
        TeamLinkCreateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling createTeamLink");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTeamLink");
        }
        String localVarPath = "/api/v2/team/{team_id}/links".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.createTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinkResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamLinkResponse>> createTeamLinkWithHttpInfoAsync(String teamId, TeamLinkCreateRequest body) {
        Invocation.Builder builder;
        TeamLinkCreateRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling createTeamLink"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTeamLink"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/links".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.createTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinkResponse>(){});
    }

    public UserTeamResponse createTeamMembership(String teamId, UserTeamRequest body) throws ApiException {
        return this.createTeamMembershipWithHttpInfo(teamId, body).getData();
    }

    public CompletableFuture<UserTeamResponse> createTeamMembershipAsync(String teamId, UserTeamRequest body) {
        return this.createTeamMembershipWithHttpInfoAsync(teamId, body).thenApply(response -> (UserTeamResponse)response.getData());
    }

    public ApiResponse<UserTeamResponse> createTeamMembershipWithHttpInfo(String teamId, UserTeamRequest body) throws ApiException {
        UserTeamRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling createTeamMembership");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTeamMembership");
        }
        String localVarPath = "/api/v2/team/{team_id}/memberships".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.createTeamMembership", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserTeamResponse>> createTeamMembershipWithHttpInfoAsync(String teamId, UserTeamRequest body) {
        Invocation.Builder builder;
        UserTeamRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling createTeamMembership"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTeamMembership"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/memberships".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.createTeamMembership", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamResponse>(){});
    }

    public void deleteTeam(String teamId) throws ApiException {
        this.deleteTeamWithHttpInfo(teamId);
    }

    public CompletableFuture<Void> deleteTeamAsync(String teamId) {
        return this.deleteTeamWithHttpInfoAsync(teamId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTeamWithHttpInfo(String teamId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteTeam");
        }
        String localVarPath = "/api/v2/team/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.deleteTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTeamWithHttpInfoAsync(String teamId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling deleteTeam"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.deleteTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteTeamLink(String teamId, String linkId) throws ApiException {
        this.deleteTeamLinkWithHttpInfo(teamId, linkId);
    }

    public CompletableFuture<Void> deleteTeamLinkAsync(String teamId, String linkId) {
        return this.deleteTeamLinkWithHttpInfoAsync(teamId, linkId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTeamLinkWithHttpInfo(String teamId, String linkId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteTeamLink");
        }
        if (linkId == null) {
            throw new ApiException(400, "Missing the required parameter 'linkId' when calling deleteTeamLink");
        }
        String localVarPath = "/api/v2/team/{team_id}/links/{link_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{link_id\\}", this.apiClient.escapeString(linkId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.deleteTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTeamLinkWithHttpInfoAsync(String teamId, String linkId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling deleteTeamLink"));
            return result;
        }
        if (linkId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'linkId' when calling deleteTeamLink"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/links/{link_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{link_id\\}", this.apiClient.escapeString(linkId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.deleteTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteTeamMembership(String teamId, String userId) throws ApiException {
        this.deleteTeamMembershipWithHttpInfo(teamId, userId);
    }

    public CompletableFuture<Void> deleteTeamMembershipAsync(String teamId, String userId) {
        return this.deleteTeamMembershipWithHttpInfoAsync(teamId, userId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTeamMembershipWithHttpInfo(String teamId, String userId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteTeamMembership");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteTeamMembership");
        }
        String localVarPath = "/api/v2/team/{team_id}/memberships/{user_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.deleteTeamMembership", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTeamMembershipWithHttpInfoAsync(String teamId, String userId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling deleteTeamMembership"));
            return result;
        }
        if (userId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling deleteTeamMembership"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/memberships/{user_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.deleteTeamMembership", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public TeamResponse getTeam(String teamId) throws ApiException {
        return this.getTeamWithHttpInfo(teamId).getData();
    }

    public CompletableFuture<TeamResponse> getTeamAsync(String teamId) {
        return this.getTeamWithHttpInfoAsync(teamId).thenApply(response -> (TeamResponse)response.getData());
    }

    public ApiResponse<TeamResponse> getTeamWithHttpInfo(String teamId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getTeam");
        }
        String localVarPath = "/api/v2/team/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.getTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamResponse>> getTeamWithHttpInfoAsync(String teamId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getTeam"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.getTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamResponse>(){});
    }

    public TeamLinkResponse getTeamLink(String teamId, String linkId) throws ApiException {
        return this.getTeamLinkWithHttpInfo(teamId, linkId).getData();
    }

    public CompletableFuture<TeamLinkResponse> getTeamLinkAsync(String teamId, String linkId) {
        return this.getTeamLinkWithHttpInfoAsync(teamId, linkId).thenApply(response -> (TeamLinkResponse)response.getData());
    }

    public ApiResponse<TeamLinkResponse> getTeamLinkWithHttpInfo(String teamId, String linkId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamLink");
        }
        if (linkId == null) {
            throw new ApiException(400, "Missing the required parameter 'linkId' when calling getTeamLink");
        }
        String localVarPath = "/api/v2/team/{team_id}/links/{link_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{link_id\\}", this.apiClient.escapeString(linkId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinkResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamLinkResponse>> getTeamLinkWithHttpInfoAsync(String teamId, String linkId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamLink"));
            return result;
        }
        if (linkId == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'linkId' when calling getTeamLink"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/links/{link_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{link_id\\}", this.apiClient.escapeString(linkId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinkResponse>(){});
    }

    public TeamLinksResponse getTeamLinks(String teamId) throws ApiException {
        return this.getTeamLinksWithHttpInfo(teamId).getData();
    }

    public CompletableFuture<TeamLinksResponse> getTeamLinksAsync(String teamId) {
        return this.getTeamLinksWithHttpInfoAsync(teamId).thenApply(response -> (TeamLinksResponse)response.getData());
    }

    public ApiResponse<TeamLinksResponse> getTeamLinksWithHttpInfo(String teamId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamLinks");
        }
        String localVarPath = "/api/v2/team/{team_id}/links".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamLinks", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinksResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamLinksResponse>> getTeamLinksWithHttpInfoAsync(String teamId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamLinksResponse>> result = new CompletableFuture<ApiResponse<TeamLinksResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamLinks"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/links".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamLinks", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamLinksResponse>> result = new CompletableFuture<ApiResponse<TeamLinksResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinksResponse>(){});
    }

    public UserTeamsResponse getTeamMemberships(String teamId) throws ApiException {
        return this.getTeamMembershipsWithHttpInfo(teamId, new GetTeamMembershipsOptionalParameters()).getData();
    }

    public CompletableFuture<UserTeamsResponse> getTeamMembershipsAsync(String teamId) {
        return this.getTeamMembershipsWithHttpInfoAsync(teamId, new GetTeamMembershipsOptionalParameters()).thenApply(response -> (UserTeamsResponse)response.getData());
    }

    public UserTeamsResponse getTeamMemberships(String teamId, GetTeamMembershipsOptionalParameters parameters) throws ApiException {
        return this.getTeamMembershipsWithHttpInfo(teamId, parameters).getData();
    }

    public CompletableFuture<UserTeamsResponse> getTeamMembershipsAsync(String teamId, GetTeamMembershipsOptionalParameters parameters) {
        return this.getTeamMembershipsWithHttpInfoAsync(teamId, parameters).thenApply(response -> (UserTeamsResponse)response.getData());
    }

    public PaginationIterable<UserTeam> getTeamMembershipsWithPagination(String teamId) {
        GetTeamMembershipsOptionalParameters parameters = new GetTeamMembershipsOptionalParameters();
        return this.getTeamMembershipsWithPagination(teamId, parameters);
    }

    public PaginationIterable<UserTeam> getTeamMembershipsWithPagination(String teamId, GetTeamMembershipsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageNumber";
        Boolean valueSetterParamOptional = true;
        parameters.pageNumber(0L);
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("teamId", teamId);
        args.put("optionalParams", parameters);
        PaginationIterable<UserTeam> iterator = new PaginationIterable<UserTeam>(this, "getTeamMemberships", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<UserTeamsResponse> getTeamMembershipsWithHttpInfo(String teamId, GetTeamMembershipsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamMemberships");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        GetTeamMembershipsSort sort = parameters.sort;
        String filterKeyword = parameters.filterKeyword;
        String localVarPath = "/api/v2/team/{team_id}/memberships".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[keyword]", filterKeyword));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamMemberships", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamsResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserTeamsResponse>> getTeamMembershipsWithHttpInfoAsync(String teamId, GetTeamMembershipsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<UserTeamsResponse>> result = new CompletableFuture<ApiResponse<UserTeamsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamMemberships"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        GetTeamMembershipsSort sort = parameters.sort;
        String filterKeyword = parameters.filterKeyword;
        String localVarPath = "/api/v2/team/{team_id}/memberships".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[keyword]", filterKeyword));
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamMemberships", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserTeamsResponse>> result = new CompletableFuture<ApiResponse<UserTeamsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamsResponse>(){});
    }

    public TeamPermissionSettingsResponse getTeamPermissionSettings(String teamId) throws ApiException {
        return this.getTeamPermissionSettingsWithHttpInfo(teamId).getData();
    }

    public CompletableFuture<TeamPermissionSettingsResponse> getTeamPermissionSettingsAsync(String teamId) {
        return this.getTeamPermissionSettingsWithHttpInfoAsync(teamId).thenApply(response -> (TeamPermissionSettingsResponse)response.getData());
    }

    public ApiResponse<TeamPermissionSettingsResponse> getTeamPermissionSettingsWithHttpInfo(String teamId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamPermissionSettings");
        }
        String localVarPath = "/api/v2/team/{team_id}/permission-settings".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamPermissionSettings", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamPermissionSettingsResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamPermissionSettingsResponse>> getTeamPermissionSettingsWithHttpInfoAsync(String teamId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamPermissionSettingsResponse>> result = new CompletableFuture<ApiResponse<TeamPermissionSettingsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamPermissionSettings"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/permission-settings".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.getTeamPermissionSettings", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamPermissionSettingsResponse>> result = new CompletableFuture<ApiResponse<TeamPermissionSettingsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamPermissionSettingsResponse>(){});
    }

    public UserTeamsResponse getUserMemberships(String userUuid) throws ApiException {
        return this.getUserMembershipsWithHttpInfo(userUuid).getData();
    }

    public CompletableFuture<UserTeamsResponse> getUserMembershipsAsync(String userUuid) {
        return this.getUserMembershipsWithHttpInfoAsync(userUuid).thenApply(response -> (UserTeamsResponse)response.getData());
    }

    public ApiResponse<UserTeamsResponse> getUserMembershipsWithHttpInfo(String userUuid) throws ApiException {
        Object localVarPostBody = null;
        if (userUuid == null) {
            throw new ApiException(400, "Missing the required parameter 'userUuid' when calling getUserMemberships");
        }
        String localVarPath = "/api/v2/users/{user_uuid}/memberships".replaceAll("\\{user_uuid\\}", this.apiClient.escapeString(userUuid.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.getUserMemberships", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamsResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserTeamsResponse>> getUserMembershipsWithHttpInfoAsync(String userUuid) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userUuid == null) {
            CompletableFuture<ApiResponse<UserTeamsResponse>> result = new CompletableFuture<ApiResponse<UserTeamsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userUuid' when calling getUserMemberships"));
            return result;
        }
        String localVarPath = "/api/v2/users/{user_uuid}/memberships".replaceAll("\\{user_uuid\\}", this.apiClient.escapeString(userUuid.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.getUserMemberships", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserTeamsResponse>> result = new CompletableFuture<ApiResponse<UserTeamsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamsResponse>(){});
    }

    public TeamsResponse listTeams() throws ApiException {
        return this.listTeamsWithHttpInfo(new ListTeamsOptionalParameters()).getData();
    }

    public CompletableFuture<TeamsResponse> listTeamsAsync() {
        return this.listTeamsWithHttpInfoAsync(new ListTeamsOptionalParameters()).thenApply(response -> (TeamsResponse)response.getData());
    }

    public TeamsResponse listTeams(ListTeamsOptionalParameters parameters) throws ApiException {
        return this.listTeamsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<TeamsResponse> listTeamsAsync(ListTeamsOptionalParameters parameters) {
        return this.listTeamsWithHttpInfoAsync(parameters).thenApply(response -> (TeamsResponse)response.getData());
    }

    public PaginationIterable<Team> listTeamsWithPagination() {
        ListTeamsOptionalParameters parameters = new ListTeamsOptionalParameters();
        return this.listTeamsWithPagination(parameters);
    }

    public PaginationIterable<Team> listTeamsWithPagination(ListTeamsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageNumber";
        Boolean valueSetterParamOptional = true;
        parameters.pageNumber(0L);
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Team> iterator = new PaginationIterable<Team>(this, "listTeams", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<TeamsResponse> listTeamsWithHttpInfo(ListTeamsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        ListTeamsSort sort = parameters.sort;
        List include = parameters.include;
        String filterKeyword = parameters.filterKeyword;
        Boolean filterMe = parameters.filterMe;
        List fieldsTeam = parameters.fieldsTeam;
        String localVarPath = "/api/v2/team";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[keyword]", filterKeyword));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[me]", filterMe));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "fields[team]", fieldsTeam));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.listTeams", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamsResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamsResponse>> listTeamsWithHttpInfoAsync(ListTeamsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        ListTeamsSort sort = parameters.sort;
        List include = parameters.include;
        String filterKeyword = parameters.filterKeyword;
        Boolean filterMe = parameters.filterMe;
        List fieldsTeam = parameters.fieldsTeam;
        String localVarPath = "/api/v2/team";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[keyword]", filterKeyword));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[me]", filterMe));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "fields[team]", fieldsTeam));
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.listTeams", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamsResponse>> result = new CompletableFuture<ApiResponse<TeamsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamsResponse>(){});
    }

    public TeamResponse updateTeam(String teamId, TeamUpdateRequest body) throws ApiException {
        return this.updateTeamWithHttpInfo(teamId, body).getData();
    }

    public CompletableFuture<TeamResponse> updateTeamAsync(String teamId, TeamUpdateRequest body) {
        return this.updateTeamWithHttpInfoAsync(teamId, body).thenApply(response -> (TeamResponse)response.getData());
    }

    public ApiResponse<TeamResponse> updateTeamWithHttpInfo(String teamId, TeamUpdateRequest body) throws ApiException {
        TeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeam");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTeam");
        }
        String localVarPath = "/api/v2/team/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamResponse>> updateTeamWithHttpInfoAsync(String teamId, TeamUpdateRequest body) {
        Invocation.Builder builder;
        TeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeam"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTeam"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamResponse>> result = new CompletableFuture<ApiResponse<TeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamResponse>(){});
    }

    public TeamLinkResponse updateTeamLink(String teamId, String linkId, TeamLinkCreateRequest body) throws ApiException {
        return this.updateTeamLinkWithHttpInfo(teamId, linkId, body).getData();
    }

    public CompletableFuture<TeamLinkResponse> updateTeamLinkAsync(String teamId, String linkId, TeamLinkCreateRequest body) {
        return this.updateTeamLinkWithHttpInfoAsync(teamId, linkId, body).thenApply(response -> (TeamLinkResponse)response.getData());
    }

    public ApiResponse<TeamLinkResponse> updateTeamLinkWithHttpInfo(String teamId, String linkId, TeamLinkCreateRequest body) throws ApiException {
        TeamLinkCreateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeamLink");
        }
        if (linkId == null) {
            throw new ApiException(400, "Missing the required parameter 'linkId' when calling updateTeamLink");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTeamLink");
        }
        String localVarPath = "/api/v2/team/{team_id}/links/{link_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{link_id\\}", this.apiClient.escapeString(linkId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinkResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamLinkResponse>> updateTeamLinkWithHttpInfoAsync(String teamId, String linkId, TeamLinkCreateRequest body) {
        Invocation.Builder builder;
        TeamLinkCreateRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeamLink"));
            return result;
        }
        if (linkId == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'linkId' when calling updateTeamLink"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTeamLink"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/links/{link_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{link_id\\}", this.apiClient.escapeString(linkId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeamLink", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamLinkResponse>> result = new CompletableFuture<ApiResponse<TeamLinkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamLinkResponse>(){});
    }

    public UserTeamResponse updateTeamMembership(String teamId, String userId, UserTeamUpdateRequest body) throws ApiException {
        return this.updateTeamMembershipWithHttpInfo(teamId, userId, body).getData();
    }

    public CompletableFuture<UserTeamResponse> updateTeamMembershipAsync(String teamId, String userId, UserTeamUpdateRequest body) {
        return this.updateTeamMembershipWithHttpInfoAsync(teamId, userId, body).thenApply(response -> (UserTeamResponse)response.getData());
    }

    public ApiResponse<UserTeamResponse> updateTeamMembershipWithHttpInfo(String teamId, String userId, UserTeamUpdateRequest body) throws ApiException {
        UserTeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeamMembership");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateTeamMembership");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTeamMembership");
        }
        String localVarPath = "/api/v2/team/{team_id}/memberships/{user_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeamMembership", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserTeamResponse>> updateTeamMembershipWithHttpInfoAsync(String teamId, String userId, UserTeamUpdateRequest body) {
        Invocation.Builder builder;
        UserTeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeamMembership"));
            return result;
        }
        if (userId == null) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling updateTeamMembership"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTeamMembership"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/memberships/{user_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeamMembership", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserTeamResponse>> result = new CompletableFuture<ApiResponse<UserTeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserTeamResponse>(){});
    }

    public TeamPermissionSettingResponse updateTeamPermissionSetting(String teamId, String action, TeamPermissionSettingUpdateRequest body) throws ApiException {
        return this.updateTeamPermissionSettingWithHttpInfo(teamId, action, body).getData();
    }

    public CompletableFuture<TeamPermissionSettingResponse> updateTeamPermissionSettingAsync(String teamId, String action, TeamPermissionSettingUpdateRequest body) {
        return this.updateTeamPermissionSettingWithHttpInfoAsync(teamId, action, body).thenApply(response -> (TeamPermissionSettingResponse)response.getData());
    }

    public ApiResponse<TeamPermissionSettingResponse> updateTeamPermissionSettingWithHttpInfo(String teamId, String action, TeamPermissionSettingUpdateRequest body) throws ApiException {
        TeamPermissionSettingUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeamPermissionSetting");
        }
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling updateTeamPermissionSetting");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTeamPermissionSetting");
        }
        String localVarPath = "/api/v2/team/{team_id}/permission-settings/{action}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeamPermissionSetting", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamPermissionSettingResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamPermissionSettingResponse>> updateTeamPermissionSettingWithHttpInfoAsync(String teamId, String action, TeamPermissionSettingUpdateRequest body) {
        Invocation.Builder builder;
        TeamPermissionSettingUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamPermissionSettingResponse>> result = new CompletableFuture<ApiResponse<TeamPermissionSettingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling updateTeamPermissionSetting"));
            return result;
        }
        if (action == null) {
            CompletableFuture<ApiResponse<TeamPermissionSettingResponse>> result = new CompletableFuture<ApiResponse<TeamPermissionSettingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'action' when calling updateTeamPermissionSetting"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<TeamPermissionSettingResponse>> result = new CompletableFuture<ApiResponse<TeamPermissionSettingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTeamPermissionSetting"));
            return result;
        }
        String localVarPath = "/api/v2/team/{team_id}/permission-settings/{action}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamsApi.updateTeamPermissionSetting", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamPermissionSettingResponse>> result = new CompletableFuture<ApiResponse<TeamPermissionSettingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamPermissionSettingResponse>(){});
    }

    public static class ListTeamsOptionalParameters {
        private Long pageNumber;
        private Long pageSize;
        private ListTeamsSort sort;
        private List<ListTeamsInclude> include;
        private String filterKeyword;
        private Boolean filterMe;
        private List<TeamsField> fieldsTeam;

        public ListTeamsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListTeamsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListTeamsOptionalParameters sort(ListTeamsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListTeamsOptionalParameters include(List<ListTeamsInclude> include) {
            this.include = include;
            return this;
        }

        public ListTeamsOptionalParameters filterKeyword(String filterKeyword) {
            this.filterKeyword = filterKeyword;
            return this;
        }

        public ListTeamsOptionalParameters filterMe(Boolean filterMe) {
            this.filterMe = filterMe;
            return this;
        }

        public ListTeamsOptionalParameters fieldsTeam(List<TeamsField> fieldsTeam) {
            this.fieldsTeam = fieldsTeam;
            return this;
        }
    }

    public static class GetTeamMembershipsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private GetTeamMembershipsSort sort;
        private String filterKeyword;

        public GetTeamMembershipsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetTeamMembershipsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public GetTeamMembershipsOptionalParameters sort(GetTeamMembershipsSort sort) {
            this.sort = sort;
            return this;
        }

        public GetTeamMembershipsOptionalParameters filterKeyword(String filterKeyword) {
            this.filterKeyword = filterKeyword;
            return this;
        }
    }
}

