/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CloudConfigurationRuleCaseCreate;
import com.datadog.api.client.v2.model.CloudConfigurationRuleComplianceSignalOptions;
import com.datadog.api.client.v2.model.CloudConfigurationRuleOptions;
import com.datadog.api.client.v2.model.CloudConfigurationRuleType;
import com.datadog.api.client.v2.model.SecurityMonitoringFilter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"cases", "complianceSignalOptions", "filters", "isEnabled", "message", "name", "options", "tags", "type"})
public class CloudConfigurationRulePayload {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CASES = "cases";
    private List<CloudConfigurationRuleCaseCreate> cases = new ArrayList<CloudConfigurationRuleCaseCreate>();
    public static final String JSON_PROPERTY_COMPLIANCE_SIGNAL_OPTIONS = "complianceSignalOptions";
    private CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<SecurityMonitoringFilter> filters = null;
    public static final String JSON_PROPERTY_IS_ENABLED = "isEnabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private CloudConfigurationRuleOptions options;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CloudConfigurationRuleType type;
    private Map<String, Object> additionalProperties;

    public CloudConfigurationRulePayload() {
    }

    @JsonCreator
    public CloudConfigurationRulePayload(@JsonProperty(required=true, value="cases") List<CloudConfigurationRuleCaseCreate> cases, @JsonProperty(required=true, value="complianceSignalOptions") CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions, @JsonProperty(required=true, value="isEnabled") Boolean isEnabled, @JsonProperty(required=true, value="message") String message, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="options") CloudConfigurationRuleOptions options) {
        this.cases = cases;
        this.complianceSignalOptions = complianceSignalOptions;
        this.unparsed |= complianceSignalOptions.unparsed;
        this.isEnabled = isEnabled;
        this.message = message;
        this.name = name;
        this.options = options;
        this.unparsed |= options.unparsed;
    }

    public CloudConfigurationRulePayload cases(List<CloudConfigurationRuleCaseCreate> cases) {
        this.cases = cases;
        for (CloudConfigurationRuleCaseCreate item : cases) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public CloudConfigurationRulePayload addCasesItem(CloudConfigurationRuleCaseCreate casesItem) {
        this.cases.add(casesItem);
        this.unparsed |= casesItem.unparsed;
        return this;
    }

    @JsonProperty(value="cases")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<CloudConfigurationRuleCaseCreate> getCases() {
        return this.cases;
    }

    public void setCases(List<CloudConfigurationRuleCaseCreate> cases) {
        this.cases = cases;
    }

    public CloudConfigurationRulePayload complianceSignalOptions(CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions) {
        this.complianceSignalOptions = complianceSignalOptions;
        this.unparsed |= complianceSignalOptions.unparsed;
        return this;
    }

    @JsonProperty(value="complianceSignalOptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CloudConfigurationRuleComplianceSignalOptions getComplianceSignalOptions() {
        return this.complianceSignalOptions;
    }

    public void setComplianceSignalOptions(CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions) {
        this.complianceSignalOptions = complianceSignalOptions;
    }

    public CloudConfigurationRulePayload filters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
        for (SecurityMonitoringFilter item : filters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public CloudConfigurationRulePayload addFiltersItem(SecurityMonitoringFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<SecurityMonitoringFilter>();
        }
        this.filters.add(filtersItem);
        this.unparsed |= filtersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
    }

    public CloudConfigurationRulePayload isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @JsonProperty(value="isEnabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public CloudConfigurationRulePayload message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CloudConfigurationRulePayload name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CloudConfigurationRulePayload options(CloudConfigurationRuleOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CloudConfigurationRuleOptions getOptions() {
        return this.options;
    }

    public void setOptions(CloudConfigurationRuleOptions options) {
        this.options = options;
    }

    public CloudConfigurationRulePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CloudConfigurationRulePayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CloudConfigurationRulePayload type(CloudConfigurationRuleType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CloudConfigurationRuleType getType() {
        return this.type;
    }

    public void setType(CloudConfigurationRuleType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CloudConfigurationRulePayload putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudConfigurationRulePayload cloudConfigurationRulePayload = (CloudConfigurationRulePayload)o;
        return Objects.equals(this.cases, cloudConfigurationRulePayload.cases) && Objects.equals(this.complianceSignalOptions, cloudConfigurationRulePayload.complianceSignalOptions) && Objects.equals(this.filters, cloudConfigurationRulePayload.filters) && Objects.equals(this.isEnabled, cloudConfigurationRulePayload.isEnabled) && Objects.equals(this.message, cloudConfigurationRulePayload.message) && Objects.equals(this.name, cloudConfigurationRulePayload.name) && Objects.equals(this.options, cloudConfigurationRulePayload.options) && Objects.equals(this.tags, cloudConfigurationRulePayload.tags) && Objects.equals(this.type, cloudConfigurationRulePayload.type) && Objects.equals(this.additionalProperties, cloudConfigurationRulePayload.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cases, this.complianceSignalOptions, this.filters, this.isEnabled, this.message, this.name, this.options, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudConfigurationRulePayload {\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    complianceSignalOptions: ").append(this.toIndentedString(this.complianceSignalOptions)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

