/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DORAGitInfo;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"env", "finished_at", "git", "id", "name", "services", "severity", "started_at", "team", "version"})
public class DORAIncidentRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ENV = "env";
    private String env;
    public static final String JSON_PROPERTY_FINISHED_AT = "finished_at";
    private Long finishedAt;
    public static final String JSON_PROPERTY_GIT = "git";
    private DORAGitInfo git;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<String> services = null;
    public static final String JSON_PROPERTY_SEVERITY = "severity";
    private String severity;
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    private Long startedAt;
    public static final String JSON_PROPERTY_TEAM = "team";
    private String team;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    private Map<String, Object> additionalProperties;

    public DORAIncidentRequestAttributes() {
    }

    @JsonCreator
    public DORAIncidentRequestAttributes(@JsonProperty(required=true, value="started_at") Long startedAt) {
        this.startedAt = startedAt;
    }

    public DORAIncidentRequestAttributes env(String env) {
        this.env = env;
        return this;
    }

    @Nullable
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public DORAIncidentRequestAttributes finishedAt(Long finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="finished_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(Long finishedAt) {
        this.finishedAt = finishedAt;
    }

    public DORAIncidentRequestAttributes git(DORAGitInfo git) {
        this.git = git;
        this.unparsed |= git.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="git")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DORAGitInfo getGit() {
        return this.git;
    }

    public void setGit(DORAGitInfo git) {
        this.git = git;
    }

    public DORAIncidentRequestAttributes id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DORAIncidentRequestAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DORAIncidentRequestAttributes services(List<String> services) {
        this.services = services;
        return this;
    }

    public DORAIncidentRequestAttributes addServicesItem(String servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public DORAIncidentRequestAttributes severity(String severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @JsonProperty(value="severity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public DORAIncidentRequestAttributes startedAt(Long startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @JsonProperty(value="started_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public DORAIncidentRequestAttributes team(String team) {
        this.team = team;
        return this;
    }

    @Nullable
    @JsonProperty(value="team")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public DORAIncidentRequestAttributes version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonAnySetter
    public DORAIncidentRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DORAIncidentRequestAttributes doraIncidentRequestAttributes = (DORAIncidentRequestAttributes)o;
        return Objects.equals(this.env, doraIncidentRequestAttributes.env) && Objects.equals(this.finishedAt, doraIncidentRequestAttributes.finishedAt) && Objects.equals(this.git, doraIncidentRequestAttributes.git) && Objects.equals(this.id, doraIncidentRequestAttributes.id) && Objects.equals(this.name, doraIncidentRequestAttributes.name) && Objects.equals(this.services, doraIncidentRequestAttributes.services) && Objects.equals(this.severity, doraIncidentRequestAttributes.severity) && Objects.equals(this.startedAt, doraIncidentRequestAttributes.startedAt) && Objects.equals(this.team, doraIncidentRequestAttributes.team) && Objects.equals(this.version, doraIncidentRequestAttributes.version) && Objects.equals(this.additionalProperties, doraIncidentRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.finishedAt, this.git, this.id, this.name, this.services, this.severity, this.startedAt, this.team, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DORAIncidentRequestAttributes {\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    git: ").append(this.toIndentedString(this.git)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

