/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.gateway;

public interface Flow<T> {
    public Action getAction();

    public T getResult();

    public static class ResultFlow<R>
    implements Flow<R> {
        private static final ResultFlow EMPTY = new ResultFlow<Object>(null);
        private final R result;

        public static <R> ResultFlow<R> empty() {
            return EMPTY;
        }

        public ResultFlow(R result) {
            this.result = result;
        }

        @Override
        public Action getAction() {
            return Action.Noop.INSTANCE;
        }

        @Override
        public R getResult() {
            return this.result;
        }
    }

    public static interface Action {
        public boolean isBlocking();

        public static final class Throw
        implements Action {
            private final Exception exception;

            public Throw(Exception exception) {
                this.exception = exception;
            }

            @Override
            public boolean isBlocking() {
                return true;
            }

            public Exception getBlockingException() {
                return this.exception;
            }
        }

        public static class Noop
        implements Action {
            public static Action INSTANCE = new Noop();

            private Noop() {
            }

            @Override
            public boolean isBlocking() {
                return false;
            }
        }
    }
}

