/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Checkpointer;
import datadog.trace.api.Config;
import datadog.trace.api.Platform;
import datadog.trace.api.StatsDClientManager;
import datadog.trace.api.Tracer;
import datadog.trace.api.WithGlobalTracer;
import datadog.trace.api.gateway.InstrumentationGateway;
import datadog.trace.api.gateway.SubscriptionService;
import datadog.trace.bootstrap.Library;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.context.ScopeListener;
import datadog.trace.util.AgentTaskScheduler;
import datadog.trace.util.AgentThreadFactory;
import datadog.trace.util.Strings;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Agent {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "datadog.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "datadog.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[dd.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "datadog.slf4j.simpleLogger.defaultLogLevel";
    private static final int DEFAULT_JMX_START_DELAY = 15;
    private static final Logger log;
    private static final String AGENT_INSTALLER_CLASS_NAME;
    private static final AtomicBoolean jmxStarting;
    private static ClassLoader SHARED_CLASSLOADER;
    private static ClassLoader BOOTSTRAP_PROXY;
    private static ClassLoader AGENT_CLASSLOADER;
    private static ClassLoader JMXFETCH_CLASSLOADER;
    private static ClassLoader PROFILING_CLASSLOADER;
    private static ClassLoader APPSEC_CLASSLOADER;
    private static volatile AgentTaskScheduler.Task<URL> PROFILER_INIT_AFTER_JMX;
    private static boolean jmxFetchEnabled;
    private static boolean profilingEnabled;
    private static boolean appSecEnabled;
    private static boolean cwsEnabled;
    private static boolean ciVisibilityEnabled;

    public static void start(Instrumentation inst, URL bootstrapURL) {
        Agent.createSharedClassloader(bootstrapURL);
        if ("true".equals(Agent.ddGetProperty("dd.integration.junit.enabled")) || "true".equals(Agent.ddGetProperty("dd.integration.testng.enabled"))) {
            Agent.setSystemPropertyDefault(AgentFeature.CIVISIBILITY.getSystemProp(), "true");
        }
        if (ciVisibilityEnabled = Agent.isFeatureEnabled(AgentFeature.CIVISIBILITY)) {
            Agent.setSystemPropertyDefault(AgentFeature.TRACING.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.JMXFETCH.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.PROFILING.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.APPSEC.getSystemProp(), "false");
            Agent.setSystemPropertyDefault(AgentFeature.CWS.getSystemProp(), "false");
            Agent.setSystemPropertyDefault("dd.prioritization.type", "ENSURE_TRACE");
            boolean ciVisibilityAgentlessEnabled = Agent.isFeatureEnabled(AgentFeature.CIVISIBILITY_AGENTLESS);
            if (ciVisibilityAgentlessEnabled) {
                Agent.setSystemPropertyDefault("dd.writer.type", "DDIntakeWriter");
            }
        }
        jmxFetchEnabled = Agent.isFeatureEnabled(AgentFeature.JMXFETCH);
        profilingEnabled = Agent.isFeatureEnabled(AgentFeature.PROFILING);
        appSecEnabled = Agent.isFeatureEnabled(AgentFeature.APPSEC);
        cwsEnabled = Agent.isFeatureEnabled(AgentFeature.CWS);
        if (profilingEnabled) {
            if (!Platform.isOracleJDK8()) {
                Agent.startProfilingAgent(bootstrapURL, true);
            } else {
                log.debug("Oracle JDK 8 detected. Delaying profiler initialization.");
                PROFILER_INIT_AFTER_JMX = new AgentTaskScheduler.Task<URL>(){

                    @Override
                    public void run(URL target) {
                        Agent.startProfilingAgent(target, false);
                    }
                };
            }
        }
        if (cwsEnabled) {
            Agent.startCwsAgent();
        }
        AgentTaskScheduler.initialize();
        Agent.startDatadogAgent(inst, bootstrapURL);
        if (appSecEnabled) {
            if (Platform.isJavaVersionAtLeast(8)) {
                try {
                    APPSEC_CLASSLOADER = Agent.createDelegateClassLoader("appsec", bootstrapURL, SHARED_CLASSLOADER);
                }
                catch (Exception e) {
                    log.error("Error creating appsec classloader", e);
                }
            } else {
                log.warn("AppSec System requires Java 8 or later to run");
            }
        }
        EnumSet<Library> libraries = Library.detectLibraries(log);
        boolean appUsingCustomLogManager = Agent.isAppUsingCustomLogManager(libraries);
        boolean appUsingCustomJMXBuilder = Agent.isAppUsingCustomJMXBuilder(libraries);
        if (jmxFetchEnabled || profilingEnabled) {
            int jmxStartDelay = Agent.getJmxStartDelay();
            if (appUsingCustomJMXBuilder) {
                log.debug("Custom JMX builder detected. Delaying JMXFetch initialization.");
                Agent.registerMBeanServerBuilderCallback(new StartJmxCallback(bootstrapURL, jmxStartDelay));
                Agent.scheduleJmxStart(bootstrapURL, 60 + jmxStartDelay);
            } else if (appUsingCustomLogManager) {
                log.debug("Custom logger detected. Delaying JMXFetch initialization.");
                Agent.registerLogManagerCallback(new StartJmxCallback(bootstrapURL, jmxStartDelay));
            } else {
                Agent.scheduleJmxStart(bootstrapURL, jmxStartDelay);
            }
        }
        InstallDatadogTracerCallback installDatadogTracerCallback = new InstallDatadogTracerCallback(bootstrapURL);
        if (Agent.isJavaBefore9WithJFR() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Datadog Tracer initialization.");
            Agent.registerLogManagerCallback(installDatadogTracerCallback);
        } else {
            installDatadogTracerCallback.execute();
        }
        if (profilingEnabled && !Platform.isOracleJDK8()) {
            if (!Platform.isJavaVersionAtLeast(9) && appUsingCustomLogManager) {
                log.debug("Custom logger detected. Delaying JMXFetch initialization.");
                Agent.registerLogManagerCallback(new StartProfilingAgentCallback(bootstrapURL));
            } else {
                Agent.startProfilingAgent(bootstrapURL, false);
            }
        }
    }

    public static synchronized Class<?> installAgentCLI(URL bootstrapURL) throws Exception {
        Agent.createSharedClassloader(bootstrapURL);
        if (null == AGENT_CLASSLOADER) {
            AGENT_CLASSLOADER = Agent.createDelegateClassLoader("inst", bootstrapURL, SHARED_CLASSLOADER);
        }
        return AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.AgentCLI");
    }

    private static void registerLogManagerCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass(AGENT_INSTALLER_CLASS_NAME);
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for {}", (Object)callback.agentThread(), (Object)ex);
        }
    }

    private static void registerMBeanServerBuilderCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass(AGENT_INSTALLER_CLASS_NAME);
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "javax.management.MBeanServerBuilder", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for {}", (Object)callback.agentThread(), (Object)ex);
        }
    }

    private static synchronized void createSharedClassloader(URL bootstrapURL) {
        if (SHARED_CLASSLOADER == null) {
            try {
                Class<?> bootstrapProxyClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader$BootstrapClassLoaderProxy");
                Constructor<?> constructor = bootstrapProxyClass.getDeclaredConstructor(URL.class);
                BOOTSTRAP_PROXY = (ClassLoader)constructor.newInstance(bootstrapURL);
                ClassLoader parent = Agent.class.getClassLoader();
                if (parent == null && Platform.isJavaVersionAtLeast(9)) {
                    parent = Agent.getPlatformClassLoader();
                }
                SHARED_CLASSLOADER = Agent.createDatadogClassLoader("shared", bootstrapURL, parent);
            }
            catch (Throwable ex) {
                log.error("Throwable thrown creating shared classloader", ex);
            }
        }
    }

    private static synchronized void startDatadogAgent(Instrumentation inst, URL bootstrapURL) {
        if (AGENT_CLASSLOADER == null) {
            try {
                ClassLoader agentClassLoader = Agent.createDelegateClassLoader("inst", bootstrapURL, SHARED_CLASSLOADER);
                Class<?> agentInstallerClass = agentClassLoader.loadClass(AGENT_INSTALLER_CLASS_NAME);
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                agentInstallerMethod.invoke(null, inst);
                AGENT_CLASSLOADER = agentClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while installing the Datadog Agent", ex);
            }
        }
    }

    private static synchronized void installDatadogTracer(Class<?> scoClass, Object sco) {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        try {
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.TracerInstaller");
            Method tracerInstallerMethod = tracerInstallerClass.getMethod("installGlobalTracer", scoClass);
            tracerInstallerMethod.invoke(null, sco);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while installing the Datadog Tracer", ex);
        }
    }

    private static void scheduleJmxStart(URL bootstrapURL, int jmxStartDelay) {
        if (jmxStartDelay > 0) {
            AgentTaskScheduler.INSTANCE.scheduleWithJitter(new JmxStartTask(), bootstrapURL, jmxStartDelay, TimeUnit.SECONDS);
        } else {
            Agent.startJmx(bootstrapURL);
        }
    }

    private static synchronized void startJmx(URL bootstrapURL) {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        if (jmxStarting.getAndSet(true)) {
            return;
        }
        if (jmxFetchEnabled) {
            Agent.startJmxFetch(bootstrapURL);
        }
        Agent.initializeJmxSystemAccessProvider(AGENT_CLASSLOADER);
        if (profilingEnabled) {
            Agent.registerDeadlockDetectionEvent(bootstrapURL);
            if (PROFILER_INIT_AFTER_JMX != null) {
                if (Agent.getJmxStartDelay() == 0) {
                    log.debug("Waiting for profiler initialization");
                    AgentTaskScheduler.INSTANCE.scheduleWithJitter(PROFILER_INIT_AFTER_JMX, bootstrapURL, 500L, TimeUnit.MILLISECONDS);
                } else {
                    log.debug("Initializing profiler");
                    PROFILER_INIT_AFTER_JMX.run(bootstrapURL);
                }
                PROFILER_INIT_AFTER_JMX = null;
            }
        }
    }

    private static synchronized void registerDeadlockDetectionEvent(URL bootstrapUrl) {
        log.debug("Initializing JMX thread deadlock detector");
        try {
            ClassLoader classLoader = Agent.getProfilingClassloader(bootstrapUrl);
            Class<?> deadlockFactoryClass = classLoader.loadClass("com.datadog.profiling.controller.openjdk.events.DeadlockEventFactory");
            Method registerMethod = deadlockFactoryClass.getMethod("registerEvents", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError ignored) {
            log.debug("JMX deadlock detection not supported");
        }
        catch (Throwable ex) {
            log.error("Unable to initialize JMX thread deadlock detector", ex);
        }
    }

    private static synchronized void initializeJmxSystemAccessProvider(ClassLoader classLoader) {
        if (log.isDebugEnabled()) {
            log.debug("Initializing JMX system access provider for " + classLoader.toString());
        }
        try {
            Class<?> tracerInstallerClass = classLoader.loadClass("datadog.trace.agent.core.util.SystemAccess");
            Method enableJmxMethod = tracerInstallerClass.getMethod("enableJmx", new Class[0]);
            enableJmxMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while initializing JMX system access provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startJmxFetch(URL bootstrapURL) {
        if (JMXFETCH_CLASSLOADER == null) {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader jmxFetchClassLoader = Agent.createDelegateClassLoader("metrics", bootstrapURL, SHARED_CLASSLOADER);
                Thread.currentThread().setContextClassLoader(jmxFetchClassLoader);
                Class<?> jmxFetchAgentClass = jmxFetchClassLoader.loadClass("datadog.trace.agent.jmxfetch.JMXFetch");
                Method jmxFetchInstallerMethod = jmxFetchAgentClass.getMethod("run", StatsDClientManager.class);
                jmxFetchInstallerMethod.invoke(null, Agent.statsDClientManager());
                JMXFETCH_CLASSLOADER = jmxFetchClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while starting JmxFetch", ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
    }

    private static StatsDClientManager statsDClientManager() throws Exception {
        Class<?> statsdClientManagerClass = SHARED_CLASSLOADER.loadClass("datadog.communication.monitor.DDAgentStatsDClientManager");
        Method statsDClientManagerMethod = statsdClientManagerClass.getMethod("statsDClientManager", new Class[0]);
        return (StatsDClientManager)statsDClientManagerMethod.invoke(null, new Object[0]);
    }

    private static void maybeStartAppSec(Class<?> scoClass, Object o) {
        if (APPSEC_CLASSLOADER == null) {
            return;
        }
        InstrumentationGateway gw = AgentTracer.get().instrumentationGateway();
        Agent.startAppSec(gw, scoClass, o);
    }

    private static void startAppSec(InstrumentationGateway gw, Class<?> scoClass, Object sco) {
        try {
            Class<?> appSecSysClass = APPSEC_CLASSLOADER.loadClass("com.datadog.appsec.AppSecSystem");
            Method appSecInstallerMethod = appSecSysClass.getMethod("start", SubscriptionService.class, scoClass);
            appSecInstallerMethod.invoke(null, gw, sco);
        }
        catch (Throwable ex) {
            log.warn("Not starting AppSec subsystem: {}", (Object)ex.getMessage());
        }
    }

    private static void startCwsAgent() {
        log.debug("Scheduling scope event factory registration");
        WithGlobalTracer.registerOrExecute(new WithGlobalTracer.Callback(){

            @Override
            public void withTracer(Tracer tracer) {
                log.debug("Registering CWS scope tracker");
                try {
                    ScopeListener scopeListener = (ScopeListener)AGENT_CLASSLOADER.loadClass("datadog.cws.tls.TlsScopeListener").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    tracer.addScopeListener(scopeListener);
                    log.debug("Scope event factory {} has been registered", (Object)scopeListener);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    log.debug("CWS is not available. {}", (Object)e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startProfilingAgent(URL bootstrapURL, boolean isStartingFirst) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = Agent.getProfilingClassloader(bootstrapURL);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> profilingAgentClass = classLoader.loadClass("com.datadog.profiling.agent.ProfilingAgent");
            Method profilingInstallerMethod = profilingAgentClass.getMethod("run", Boolean.TYPE, ClassLoader.class);
            profilingInstallerMethod.invoke(null, isStartingFirst, AGENT_CLASSLOADER);
            if (!isStartingFirst) {
                log.debug("Scheduling scope event factory registration");
                WithGlobalTracer.registerOrExecute(new WithGlobalTracer.Callback(){

                    @Override
                    public void withTracer(Tracer tracer) {
                        try {
                            if (Config.get().isProfilingLegacyTracingIntegrationEnabled()) {
                                log.debug("Registering scope event factory");
                                ScopeListener scopeListener = (ScopeListener)AGENT_CLASSLOADER.loadClass("datadog.trace.agent.core.jfr.openjdk.ScopeEventFactory").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                tracer.addScopeListener(scopeListener);
                                log.debug("Scope event factory {} has been registered", (Object)scopeListener);
                            } else if (tracer instanceof AgentTracer.TracerAPI) {
                                log.debug("Registering checkpointer");
                                Checkpointer checkpointer = (Checkpointer)AGENT_CLASSLOADER.loadClass("datadog.trace.agent.core.jfr.openjdk.JFRCheckpointer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                ((AgentTracer.TracerAPI)tracer).registerCheckpointer(checkpointer);
                                log.debug("Checkpointer {} has been registered", (Object)checkpointer);
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof InvocationTargetException) {
                                e = e.getCause();
                            }
                            log.debug("Profiling code hotspots are not available. {}", (Object)e.getMessage());
                        }
                    }
                });
            }
        }
        catch (ClassFormatError e) {
            log.debug("Profiling requires OpenJDK 8 or above - skipping");
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while starting profiling agent", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    private static synchronized ClassLoader getProfilingClassloader(URL bootstrapURL) throws Exception {
        if (PROFILING_CLASSLOADER == null) {
            PROFILING_CLASSLOADER = Agent.createDelegateClassLoader("profiling", bootstrapURL, SHARED_CLASSLOADER);
        }
        return PROFILING_CLASSLOADER;
    }

    private static void configureLogger() {
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (Agent.isDebugMode()) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
        } else if (!Agent.isFeatureEnabled(AgentFeature.STARTUP_LOGS)) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "WARN");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null && Agent.ddGetEnv(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createDatadogClassLoader(String innerJarFilename, URL bootstrapURL, ClassLoader parent) throws Exception {
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, BOOTSTRAP_PROXY, parent);
    }

    private static ClassLoader createDelegateClassLoader(String innerJarFilename, URL bootstrapURL, ClassLoader parent) throws Exception {
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader$DelegateClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class, ClassLoader.class, ClassLoader.class);
        ClassLoader classLoader = (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, BOOTSTRAP_PROXY, parent, SHARED_CLASSLOADER);
        return classLoader;
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = Agent.ddGetEnv("dd.trace.debug");
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isFeatureEnabled(AgentFeature feature) {
        String featureEnabledSysprop = feature.getSystemProp();
        String featureEnabled = System.getProperty(featureEnabledSysprop);
        if (featureEnabled == null) {
            featureEnabled = Agent.ddGetEnv(featureEnabledSysprop);
        }
        if (feature.isEnabledByDefault()) {
            return !"false".equalsIgnoreCase(featureEnabled) && !"0".equals(featureEnabled);
        }
        return Boolean.parseBoolean(featureEnabled) || "1".equals(featureEnabled);
    }

    private static int getJmxStartDelay() {
        String startDelay = Agent.ddGetProperty("dd.dogstatsd.start-delay");
        if (startDelay == null) {
            startDelay = Agent.ddGetProperty("dd.jmxfetch.start-delay");
        }
        if (startDelay != null) {
            try {
                return Integer.parseInt(startDelay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 15;
    }

    private static boolean isAppUsingCustomLogManager(EnumSet<Library> libraries) {
        String tracerCustomLogManSysprop = "dd.app.customlogmanager";
        String customLogManagerProp = System.getProperty("dd.app.customlogmanager");
        String customLogManagerEnv = Agent.ddGetEnv("dd.app.customlogmanager");
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: {}", (Object)customLogManagerProp);
            log.debug("Env - customlogmanager: {}", (Object)customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        if (libraries.contains((Object)Library.WILDFLY)) {
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(Strings.getResourceName(logManagerProp)) != null;
            log.debug("Prop - logging.manager: {}", (Object)logManagerProp);
            log.debug("logging.manager on system classpath: {}", (Object)onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isAppUsingCustomJMXBuilder(EnumSet<Library> libraries) {
        String tracerCustomJMXBuilderSysprop = "dd.app.customjmxbuilder";
        String customJMXBuilderProp = System.getProperty("dd.app.customjmxbuilder");
        String customJMXBuilderEnv = Agent.ddGetEnv("dd.app.customjmxbuilder");
        if (customJMXBuilderProp != null || customJMXBuilderEnv != null) {
            log.debug("Prop - customjmxbuilder: {}", (Object)customJMXBuilderProp);
            log.debug("Env - customjmxbuilder: {}", (Object)customJMXBuilderEnv);
            return Boolean.parseBoolean(customJMXBuilderProp) || Boolean.parseBoolean(customJMXBuilderEnv);
        }
        if (libraries.contains((Object)Library.WILDFLY)) {
            return true;
        }
        String jmxBuilderProp = System.getProperty("javax.management.builder.initial");
        if (jmxBuilderProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(Strings.getResourceName(jmxBuilderProp)) != null;
            log.debug("Prop - javax.management.builder.initial: {}", (Object)jmxBuilderProp);
            log.debug("javax.management.builder.initial on system classpath: {}", (Object)onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static String ddGetProperty(String sysProp) {
        String value = System.getProperty(sysProp);
        if (null == value) {
            value = Agent.ddGetEnv(sysProp);
        }
        return value;
    }

    private static String ddGetEnv(String sysProp) {
        return System.getenv(Strings.toEnvVar(sysProp));
    }

    private static boolean isJavaBefore9WithJFR() {
        if (Platform.isJavaVersionAtLeast(9)) {
            return false;
        }
        return Thread.currentThread().getContextClassLoader().getResource("jdk/jfr/Recording.class") != null;
    }

    static {
        AGENT_INSTALLER_CLASS_NAME = "false".equalsIgnoreCase(Agent.ddGetProperty("dd.legacy.agent.enabled")) ? "datadog.trace.agent.installer.AgentInstaller" : "datadog.trace.agent.tooling.AgentInstaller";
        Agent.configureLogger();
        log = LoggerFactory.getLogger(Agent.class);
        jmxStarting = new AtomicBoolean();
        SHARED_CLASSLOADER = null;
        BOOTSTRAP_PROXY = null;
        AGENT_CLASSLOADER = null;
        JMXFETCH_CLASSLOADER = null;
        PROFILING_CLASSLOADER = null;
        APPSEC_CLASSLOADER = null;
        PROFILER_INIT_AFTER_JMX = null;
        jmxFetchEnabled = true;
        profilingEnabled = false;
        appSecEnabled = false;
        cwsEnabled = false;
        ciVisibilityEnabled = false;
    }

    static final class JmxStartTask
    implements AgentTaskScheduler.Task<URL> {
        JmxStartTask() {
        }

        @Override
        public void run(URL bootstrapURL) {
            Agent.startJmx(bootstrapURL);
        }
    }

    protected static class StartProfilingAgentCallback
    extends ClassLoadCallBack {
        StartProfilingAgentCallback(URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.PROFILER_STARTUP;
        }

        @Override
        public void execute() {
            Agent.startProfilingAgent(this.bootstrapURL, false);
        }
    }

    protected static class InstallDatadogTracerCallback
    extends ClassLoadCallBack {
        InstallDatadogTracerCallback(URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.TRACE_STARTUP;
        }

        @Override
        public void execute() {
            Object sco;
            Class<?> scoClass;
            try {
                scoClass = SHARED_CLASSLOADER.loadClass("datadog.communication.ddagent.SharedCommunicationObjects");
                sco = scoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new UndeclaredThrowableException(e);
            }
            Agent.installDatadogTracer(scoClass, sco);
            Agent.maybeStartAppSec(scoClass, sco);
        }
    }

    protected static class StartJmxCallback
    extends ClassLoadCallBack {
        private final int jmxStartDelay;

        StartJmxCallback(URL bootstrapURL, int jmxStartDelay) {
            super(bootstrapURL);
            this.jmxStartDelay = jmxStartDelay;
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.JMX_STARTUP;
        }

        @Override
        public void execute() {
            Agent.scheduleJmxStart(this.bootstrapURL, this.jmxStartDelay);
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        final URL bootstrapURL;

        ClassLoadCallBack(URL bootstrapURL) {
            this.bootstrapURL = bootstrapURL;
        }

        @Override
        public void run() {
            Thread thread = AgentThreadFactory.newAgentThread(this.agentThread(), new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassLoadCallBack.this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run {}", (Object)ClassLoadCallBack.this.agentThread(), (Object)e);
                    }
                }
            });
            thread.start();
        }

        public abstract AgentThreadFactory.AgentThread agentThread();

        public abstract void execute();
    }

    private static enum AgentFeature {
        TRACING("dd.tracing.enabled", true),
        JMXFETCH("dd.jmxfetch.enabled", true),
        STARTUP_LOGS("dd.trace.startup.logs", true),
        PROFILING("dd.profiling.enabled", false),
        APPSEC("dd.appsec.enabled", false),
        CWS("dd.cws.enabled", false),
        CIVISIBILITY("dd.civisibility.enabled", false),
        CIVISIBILITY_AGENTLESS("dd.civisibility.agentless.enabled", false);

        private final String systemProp;
        private final boolean enabledByDefault;

        private AgentFeature(String systemProp, boolean enabledByDefault) {
            this.systemProp = systemProp;
            this.enabledByDefault = enabledByDefault;
        }

        public String getSystemProp() {
            return this.systemProp;
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }
    }
}

