/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;

public final class AgentJar {
    private static final Class<?> thisClass = AgentJar.class;

    public static void main(String[] args) {
        if (args.length == 0) {
            AgentJar.printAgentVersion();
        } else {
            try {
                switch (args[0]) {
                    case "sampleTrace": {
                        AgentJar.sendSampleTrace(args);
                        break;
                    }
                    case "--list-integrations": 
                    case "-li": {
                        AgentJar.printIntegrationNames();
                        break;
                    }
                    case "--help": 
                    case "-h": {
                        AgentJar.printUsage();
                        break;
                    }
                    case "--version": 
                    case "-v": {
                        AgentJar.printAgentVersion();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(args[0]);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("unknown option: " + e.getMessage());
                AgentJar.printUsage();
            }
            catch (Throwable e) {
                System.out.println("Failed to process agent option");
                e.printStackTrace();
            }
        }
    }

    private static void printUsage() {
        System.out.println("usage: sampleTrace [-c count] [-i interval]");
        System.out.println("       [-li | --list-integrations]");
        System.out.println("       [-h  | --help]");
        System.out.println("       [-v  | --version]");
    }

    private static void sendSampleTrace(String[] args) throws Exception {
        int count = -1;
        double interval = 1.0;
        if (args.length % 2 == 0) {
            throw new IllegalArgumentException("missing value");
        }
        block8: for (int i = 1; i < args.length; i += 2) {
            switch (args[i]) {
                case "-c": {
                    count = Integer.parseInt(args[i + 1]);
                    continue block8;
                }
                case "-i": {
                    interval = Double.parseDouble(args[i + 1]);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException(args[i]);
                }
            }
        }
        AgentJar.installAgentCLI().getMethod("sendSampleTraces", Integer.TYPE, Double.TYPE).invoke(null, count, interval);
    }

    private static void printIntegrationNames() throws Exception {
        AgentJar.installAgentCLI().getMethod("printIntegrationNames", new Class[0]).invoke(null, new Object[0]);
    }

    private static Class<?> installAgentCLI() throws Exception {
        CodeSource codeSource = thisClass.getProtectionDomain().getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) {
            throw new MalformedURLException("Could not get jar location from code source");
        }
        Class<?> agentClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.Agent");
        Method installAgentCLIMethod = agentClass.getMethod("installAgentCLI", URL.class);
        return (Class)installAgentCLIMethod.invoke(null, codeSource.getLocation());
    }

    private static void printAgentVersion() {
        try {
            System.out.println(AgentJar.getAgentVersion());
        }
        catch (Exception e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }

    public static String getAgentVersion() throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(thisClass.getResourceAsStream("/dd-java-agent.version"), StandardCharsets.UTF_8));){
            int c = reader.read();
            while (c != -1) {
                sb.append((char)c);
                c = reader.read();
            }
        }
        return sb.toString().trim();
    }
}

