/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.InternalJarURLHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DatadogClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DatadogClassLoader.class);
    protected final InternalJarURLHandler internalJarURLHandler;
    private final ClassLoader bootstrapProxy;
    private final String classLoaderName;
    private final JarIndex jarIndex;
    private String lastPackage = null;

    public DatadogClassLoader(URL bootstrapJarLocation, String internalJarFileName, ClassLoader bootstrapProxy, ClassLoader parent) {
        super(new URL[0], parent);
        this.jarIndex = parent instanceof DatadogClassLoader ? ((DatadogClassLoader)parent).jarIndex : new JarIndex(bootstrapJarLocation);
        this.bootstrapProxy = bootstrapProxy;
        this.classLoaderName = null == internalJarFileName ? "datadog" : internalJarFileName;
        this.internalJarURLHandler = new InternalJarURLHandler(internalJarFileName, (Set)this.jarIndex.index.get(internalJarFileName), this.jarIndex.jarFile);
        try {
            this.addURL(new URL("x-internal-jar", null, 0, "/", this.internalJarURLHandler));
        }
        catch (MalformedURLException e) {
            log.error("URL malformed.  Unsupported JDK?", e);
        }
    }

    @Override
    public URL getResource(String resourceName) {
        URL bootstrapResource = this.bootstrapProxy.getResource(resourceName);
        if (null == bootstrapResource) {
            return super.getResource(resourceName);
        }
        return bootstrapResource;
    }

    public boolean hasLoadedClass(String className) {
        return this.findLoadedClass(className) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> loadFromPackage(String packageName, String name) throws ClassNotFoundException {
        if (this.internalJarURLHandler.hasPackage(packageName)) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> loaded = this.findLoadedClass(name);
                if (loaded != null) {
                    return loaded;
                }
                if (!packageName.startsWith("java.")) {
                    return this.findClass(name);
                }
            }
        }
        return super.loadClass(name);
    }

    String getPackageName(String className) {
        String packageName = this.lastPackage;
        if (null == packageName || !className.startsWith(packageName)) {
            int end = className.lastIndexOf(46);
            if (end != -1) {
                this.lastPackage = packageName = className.substring(0, end);
            } else {
                packageName = "";
            }
        }
        return packageName;
    }

    public ClassLoader getBootstrapProxy() {
        return this.bootstrapProxy;
    }

    public String toString() {
        return this.classLoaderName;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    static final class JarIndex {
        private final HashMap<String, Set<String>> index = new HashMap();
        private final JarFile jarFile;

        private JarIndex(URL location) {
            JarFile jarFile = null;
            try {
                if (location != null) {
                    jarFile = new JarFile(new File(location.toURI()), false);
                    String currentFilePrefix = "$";
                    int prefixLength = Integer.MAX_VALUE;
                    HashSet<String> packages = null;
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!entry.isDirectory() || name.startsWith("META-INF/")) continue;
                        if (!name.startsWith(currentFilePrefix)) {
                            int end = name.indexOf(47);
                            currentFilePrefix = name.substring(0, end);
                            packages = new HashSet<String>();
                            this.index.put(currentFilePrefix, packages);
                            prefixLength = end + 1;
                        }
                        if (name.length() <= prefixLength || null == packages) continue;
                        String dir = name.substring(prefixLength, name.length() - 1);
                        String currentPackage = dir.replace('/', '.');
                        packages.add(currentPackage);
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                log.error("Unable to read internal jar", e);
            }
            this.jarFile = jarFile;
        }

        public Set<String> getPackages(String namespace) {
            return this.index.get(namespace);
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }
    }

    public static class DelegateClassLoader
    extends DatadogClassLoader {
        private final DatadogClassLoader shared;

        public DelegateClassLoader(URL bootstrapJarLocation, String internalJarFileName, ClassLoader bootstrapProxy, ClassLoader parent, ClassLoader shared) {
            super(bootstrapJarLocation, internalJarFileName, bootstrapProxy, parent);
            this.shared = (DatadogClassLoader)shared;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            String packageName = this.shared.getPackageName(name);
            if (this.internalJarURLHandler.hasPackage(packageName)) {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> loaded = this.findLoadedClass(name);
                    if (loaded != null) {
                        return loaded;
                    }
                    if (!packageName.startsWith("java.")) {
                        return this.findClass(name);
                    }
                }
            }
            return this.shared.loadFromPackage(packageName, name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static final class BootstrapClassLoaderProxy
    extends URLClassLoader {
        public BootstrapClassLoaderProxy(URL url) {
            super(new URL[]{url}, (ClassLoader)null);
        }

        public BootstrapClassLoaderProxy() {
            super(new URL[0], (ClassLoader)null);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

