/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.api.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class InternalJarURLHandler
extends URLStreamHandler {
    private static final WeakReference<Pair<String, JarEntry>> NULL = new WeakReference<Object>(null);
    private final String name;
    private final FileNotInInternalJar notFound;
    private final Set<String> packages;
    private final JarFile bootstrapJarFile;
    private WeakReference<Pair<String, JarEntry>> cache = NULL;

    InternalJarURLHandler(String internalJarFileName, Set<String> packages, JarFile jarFile) {
        this.name = internalJarFileName;
        this.notFound = new FileNotInInternalJar(internalJarFileName);
        this.packages = packages;
        this.bootstrapJarFile = jarFile;
    }

    Set<String> getPackages() {
        return this.packages;
    }

    boolean hasPackage(String packageName) {
        return this.packages.contains(packageName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String filename = url.getFile();
        if ("/".equals(filename)) {
            return new InternalJarURLConnection(url, new ByteArrayInputStream(new byte[0]), 0);
        }
        Pair<String, JarEntry> pair = (Pair<String, JarEntry>)this.cache.get();
        if (null == pair || !filename.equals(pair.getLeft())) {
            String classFileName = this.name + filename + (filename.endsWith(".class") ? "data" : "");
            JarEntry entry = this.bootstrapJarFile.getJarEntry(classFileName);
            if (null == entry) throw this.notFound;
            pair = Pair.of(filename, entry);
            this.cache = new WeakReference<Pair<String, JarEntry>>(pair);
            return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream(pair.getRight()), (int)((JarEntry)pair.getRight()).getSize());
        } else {
            this.cache = NULL;
        }
        return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream((ZipEntry)pair.getRight()), (int)((JarEntry)pair.getRight()).getSize());
    }

    private static class FileNotInInternalJar
    extends IOException {
        public FileNotInInternalJar(String jarName) {
            super("class not found in " + jarName);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class InternalJarURLConnection
    extends URLConnection {
        private final InputStream inputStream;
        private final int contentLength;

        private InternalJarURLConnection(URL url, InputStream inputStream, int contentLength) {
            super(url);
            this.inputStream = inputStream;
            this.contentLength = contentLength;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public Permission getPermission() {
            return null;
        }

        @Override
        public int getContentLength() {
            return this.contentLength;
        }
    }
}

