/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;
import datadog.trace.bootstrap.instrumentation.decorator.http.HttpResourceDecorator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;

public abstract class HttpClientDecorator<REQUEST, RESPONSE>
extends ClientDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDecorator.class);
    private static final BitSet CLIENT_ERROR_STATUSES = Config.get().getHttpClientErrorStatuses();
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");

    protected abstract String method(REQUEST var1);

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract int status(RESPONSE var1);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_CLIENT;
    }

    @Override
    protected String service() {
        return null;
    }

    protected boolean shouldSetResourceName() {
        return true;
    }

    public AgentSpan onRequest(AgentSpan span, REQUEST request) {
        if (request != null) {
            String method = this.method(request);
            span.setTag("http.method", method);
            try {
                URI url = this.url(request);
                if (url != null) {
                    String host = url.getHost();
                    String path = url.getPath();
                    int port = url.getPort();
                    span.setTag("http.url", URIUtils.buildURL(url.getScheme(), host, port, path));
                    if (null != host && !host.isEmpty()) {
                        span.setTag("peer.hostname", host);
                        if (Config.get().isHttpClientSplitByDomain() && host.charAt(0) >= 'A') {
                            span.setServiceName(host);
                        }
                        if (port > 0) {
                            this.setPeerPort(span, port);
                        }
                    }
                    if (Config.get().isHttpClientTagQueryString()) {
                        span.setTag("http.query.string", url.getQuery());
                        span.setTag("http.fragment.string", url.getFragment());
                    }
                    if (this.shouldSetResourceName()) {
                        HttpResourceDecorator.HTTP_RESOURCE_DECORATOR.withClientPath(span, method, path);
                    }
                } else if (this.shouldSetResourceName()) {
                    span.setResourceName(DEFAULT_RESOURCE_NAME);
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            int status = this.status(response);
            if (status > 0) {
                span.setHttpStatusCode(status);
            }
            if (CLIENT_ERROR_STATUSES.get(status)) {
                span.setError(true);
            }
        }
        return span;
    }
}

