/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator.http;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.function.Function;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.decorator.http.AntPathMatcher;
import datadog.trace.bootstrap.instrumentation.decorator.http.PathNormalizer;
import java.util.ArrayList;
import java.util.Map;

final class AntPatternPathNormalizer
extends PathNormalizer {
    private static final Logger log = LoggerFactory.getLogger(AntPatternPathNormalizer.class);
    private final Map<String, String> resourceNameMatchers;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final DDCache<String, String> cache = DDCaches.newFixedSizeCache(512);
    private final Function<String, String> cacheLoader = new Function<String, String>(){

        @Override
        public String apply(String path) {
            for (Map.Entry resourceNameMatcher : AntPatternPathNormalizer.this.resourceNameMatchers.entrySet()) {
                if (!AntPatternPathNormalizer.this.matcher.match((String)resourceNameMatcher.getKey(), path)) continue;
                return (String)resourceNameMatcher.getValue();
            }
            return null;
        }
    };

    AntPatternPathNormalizer(Map<String, String> httpResourceNameMatchers) {
        this.resourceNameMatchers = httpResourceNameMatchers;
        ArrayList<String> invalidPatterns = new ArrayList<String>(httpResourceNameMatchers.keySet().size());
        for (String pattern : this.resourceNameMatchers.keySet()) {
            if (this.matcher.isPattern(pattern)) continue;
            invalidPatterns.add(pattern);
        }
        for (String invalid : invalidPatterns) {
            log.warn("Invalid pattern {} removed from matchers", (Object)invalid);
            this.resourceNameMatchers.remove(invalid);
        }
    }

    @Override
    public String normalize(String path, boolean encoded) {
        if (encoded) {
            path = URIUtils.decode(path);
        }
        return this.cache.computeIfAbsent(path, this.cacheLoader);
    }
}

