/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.httpurlconnection;

import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.httpurlconnection.HttpUrlConnectionDecorator;
import java.net.HttpURLConnection;

public class HttpUrlState {
    public static final String OPERATION_NAME = "http.request";
    public static final ContextStore.Factory<HttpUrlState> FACTORY = new ContextStore.Factory<HttpUrlState>(){

        @Override
        public HttpUrlState create() {
            return new HttpUrlState();
        }
    };
    private volatile AgentSpan span = null;
    private volatile boolean finished = false;

    public AgentSpan start(HttpURLConnection connection) {
        this.span = AgentTracer.startSpan(OPERATION_NAME);
        try (AgentScope scope = AgentTracer.activateSpan(this.span);){
            HttpUrlConnectionDecorator.DECORATE.afterStart(this.span);
            HttpUrlConnectionDecorator.DECORATE.onRequest(this.span, connection);
            AgentSpan agentSpan = this.span;
            return agentSpan;
        }
    }

    public boolean hasSpan() {
        return this.span != null;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void finish() {
        this.finished = true;
    }

    public void finishSpan(int responseCode, Throwable throwable) {
        try (AgentScope scope = AgentTracer.activateSpan(this.span);){
            if (responseCode > 0) {
                HttpUrlConnectionDecorator.DECORATE.onResponse(this.span, responseCode);
            } else {
                HttpUrlConnectionDecorator.DECORATE.onError(this.span, throwable);
            }
            HttpUrlConnectionDecorator.DECORATE.beforeFinish(this.span);
            this.span.finish();
            this.span = null;
            this.finished = true;
        }
    }

    public void finishSpan(int responseCode) {
        if (responseCode > 0) {
            try (AgentScope scope = AgentTracer.activateSpan(this.span);){
                HttpUrlConnectionDecorator.DECORATE.onResponse(this.span, responseCode);
                HttpUrlConnectionDecorator.DECORATE.beforeFinish(this.span);
                this.span.finish();
                this.span = null;
                this.finished = true;
            }
        }
    }
}

